% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{plot_effects}
\alias{plot_effects}
\title{Graphics for plot effects}
\usage{
plot_effects(df, effect, blocks = TRUE, labels = TRUE)
}
\arguments{
\item{df}{A data frame with the columns 'col', 'row', and the effects to be plotted.}

\item{effect}{The name of the effects to be plotted.}

\item{blocks}{When \code{TRUE} (default), the field array is split into blocks.
This requires an additional column 'block' in the data frame.}

\item{labels}{When \code{TRUE} (default), column and row labels are displayed.}
}
\value{
A graphical field array with x- and y-axes displaying the column and row numbers,
 and colour gradient ranging from red (low value) to green (high value).
}
\description{
Creates a graphical field array for a set of plot effects (e.g., phenotypes, genetic values, or plot errors).
Requires a data frame generated with the functions \link[FieldSimR]{field_trial_error} or \link[FieldSimR]{make_phenotypes},
or any data frame matching the description below.
}
\examples{
# Display the simulated plot errors in the example data frame 'error_df_bivar'
# for Trait 1 in Environment 1.

error_df <- error_df_bivar[error_df_bivar$env == 1, ]

plot_effects(
  df = error_df,
  effect = "e.Trait1",
  labels = TRUE,
)

}
