% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GMVP.R
\name{GMVP}
\alias{GMVP}
\title{Global Minimum Variance Portfolio}
\usage{
GMVP(cov.mat, short = TRUE)
}
\arguments{
\item{cov.mat}{an estimated p*p covariance matrix}

\item{short}{logical flag, indicating whether shortsales on the
risky assets are allowed}
}
\value{
a numerical vector containing the estimated portfolio weights
}
\description{
Computing a global minimum variance portfolio weights from the estimated
covariance matrix of return series.
}
\examples{
data(m.excess.c10sp9003)
assets <- m.excess.c10sp9003[,1:10]
GMVP(cov(assets), short=TRUE)
GMVP(cov(assets), short=FALSE)
}

