% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tapering.cv.R
\name{tapering.cv}
\alias{tapering.cv}
\title{Select Tuning Parameter for Tapering Covariance Matrix by CV}
\usage{
tapering.cv(matrix, h = 1/2, n.cv = 10, norm = "F", seed = 142857)
}
\arguments{
\item{matrix}{a N*p matrix, N indicates sample size
and p indicates the dimension}

\item{h}{the ratio between taper l_h and parameter l}

\item{n.cv}{times that cross-validation repeated, the default number is 10}

\item{norm}{the norms used to measure the cross-validation errors,
which can be the Frobenius norm "F" or the operator norm "O"}

\item{seed}{random seed, the default value is 142857}
}
\value{
An object of class "CovCv" containing the cross-validation's result
  for covariance matrix regularization, including:
  \item{regularization}{regularization method, which is "Tapering"}
  \item{parameter.opt}{selected optimal parameter by cross-validation}
  \item{cv.error}{the corresponding cross-validation errors}
  \item{n.cv}{times that cross-validation repeated}
  \item{norm}{the norm used to measure the cross-validation error}
  \item{seed}{random seed}
}
\description{
Apply K-fold cross-validation for selecting tuning parameters for
tapering covariance matrix using grid search strategy
}
\details{
For cross-validation, this function split the sample randomly into
two pieces of size n1 = n-n/log(n) and n2 = n/log(n), and repeat this k times
}
\examples{
data(m.excess.c10sp9003)
retcov.cv <- tapering.cv(m.excess.c10sp9003, n.cv = 10,
                         norm = "F", seed = 142857)
summary(retcov.cv)
plot(retcov.cv)
# Low dimension
}
\references{
"High-Dimensional Covariance Estimation" by Mohsen Pourahmadi
}

