% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.respirometry.R
\name{convert.respirometry}
\alias{convert.respirometry}
\title{Convert raw respirometry data (respirometry)}
\usage{
convert.respirometry(import.file, export.file,
                     n.chamber = c(1,2,3,4,5,6,7,8),
                     logger = c("AutoResp", "FishResp", "Qbox-Aqua"),
                     from, to, sal = 0, atm_pres = 1013.25)
}
\arguments{
\item{import.file}{the name of a file with raw respirometry data which should be imported to convert DO units}

\item{export.file}{the name of a file with results of the DO unit conversion}

\item{n.chamber}{integer: the number of chambers used in an experiment (including empty ones)}

\item{logger}{string: the name of a logger software used for intermittent-flow respirometry. Note, that both 'OxyView' and 'Pyro Oxygen Logger' used in couple with the 'AquaResp' software should be converted to the 'FishResp' format before running this function (see the functions \code{\link{presens.aquaresp}} or \code{\link{pyroscience.aquaresp}}, respectively).}

\item{from}{string: dissolved oxygen unit in an imported file (more information can be found in documentation of the function \code{\link{conv_o2}}, R package \pkg{respirometry})}

\item{to}{string: dissolved oxygen unit in an exported file (more information can be found in documentation of the function \code{\link{conv_o2}}, R package \pkg{respirometry})}

\item{sal}{string: salinity is measured in ppm (more information can be found in documentation of the function \code{\link{conv_o2}}, R package \pkg{respirometry})}

\item{atm_pres}{string: ambient atmospheric pressure value (more information can be found in documentation of the function \code{\link{conv_o2}}, R package \pkg{respirometry})}
}
\value{
the function exports a data frame with converted DO units.
}
\description{
This function is a modification of the function \code{\link[respirometry]{conv_o2}} from the R package \pkg{respirometry} allowing to convert raw respirometry data from one DO unit to another obtained in multichannel respirometry systems.
}
\examples{
# Import raw data for standard metabolic rate
SMR.path = system.file("extdata/stickleback/SMR_raw.txt.xz", package = "FishResp")

convert.respirometry(import.file = SMR.path,
                     export.file = "converted_SMR_raw.txt",
                     n.chamber = 2, logger = "AutoResp",
                     from = "mg_per_l", to = "mmol_per_l",
                     sal = 0, atm_pres = 1013.25)

}
