% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_bavrn_state_short.R
\name{fe_species_bavrn_state_short}
\alias{fe_species_bavrn_state_short}
\title{Construct a \emph{fe_species_bavrn_state_short} Species Code Vector}
\usage{
fe_species_bavrn_state_short(x = character())
}
\arguments{
\item{x}{Input vector to become a vector of tree species codes by the
definition \emph{bavrn_state_short}. Any type of vector (typically
\code{integer}) which, after conversion with \code{\link{as.character}},
adheres to that definition is acceptable. If \code{x} is provided as a
character vector, leading and trailing white spaces will be trimmed.}
}
\value{
If the user input allows to construct a well-defined
\code{fe_species_bavrn_state_short} object, this object will be returned.
If not, the function will terminate with an error.
}
\description{
User interface for constructing a vector of species codes follwing the
\emph{fe_species_bavrn_state_short} convention
}
\details{
The \emph{bavrn_state_short} species coding is the species coding used by the
Bavarian State Forest Service for aggregated data evaluations. It is actually
a grouped version of the detailed \emph{bavrn_state} coding. See the example
section for how to look up the coding.
}
\examples{
# Libraries required for the following two examples
library(dplyr)
library(purrr)

# Look up the bavrn_state_short species codes for all supported species
# the column species_id contains the bavrn_state_short codes
species_codings |>
  filter(species_coding == "bavrn_state_short") |>
  pluck(2, 1) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)

# Or, use an even easier access with
fe_species_get_coding_table("bavrn_state_short")

# Display a summary table which shows the number of single species behind
# each bavrn_state_short species code
fe_species_get_coding_table("bavrn_state_short") |>
  group_by(name_eng, species_id) |> # display english names
  summarise(n = n()) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)


# Make an fe_species_bavrn_state_short vector from a vector of integer codes
spec_ids <- fe_species_bavrn_state_short(
  c(1, 1, 1, 6, 6, 6, 6, 3, 3, 8, 8, 8)
)

}
