% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Boot_Algo1_ML_30012018.R
\name{boot.mean.algo1}
\alias{boot.mean.algo1}
\title{Estimates the bootstrap distribution of the likelihood ratio LR by the Algorithm 1 using the mean}
\usage{
boot.mean.algo1(
  data.fuzzified,
  distribution,
  sig,
  nsim = 100,
  mu = NA,
  sigma = NA,
  step = 0.1,
  margin = c(5, 5),
  breakpoints = 100,
  plot = TRUE
)
}
\arguments{
\item{data.fuzzified}{a fuzzification matrix constructed by a call to the function FUZZ or the function GFUZZ, 
or a similar matrix. No NA are allowed.}

\item{distribution}{a distribution chosen between "normal", "poisson", "Student" or "Logistic".}

\item{sig}{a numerical value representing the significance level of the test.}

\item{nsim}{an integer giving the number of replications needed in the bootstrap procedure. It is set to 100 by default.}

\item{mu}{if the mean of the normal distribution is known, mu should be a numerical value. Otherwise, the argument mu is fixed to NA.}

\item{sigma}{if the standard deviation of the normal distribution is known, sigma should be a numerical value. Otherwise, the argument sigma is fixed to NA.}

\item{step}{a numerical value fixed to 0.1, defining the step of iterations on the interval [t-5; t+5].}

\item{margin}{an optional numerical couple of values fixed to [5; 5], representing the range of calculations around the parameter t.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{plot}{fixed by default to "FALSE". plot="FALSE" if a plot of the fuzzy number is not required.}
}
\value{
Returns a vector of decimals representing the bootstrap distribution of LR.
}
\description{
Estimates the bootstrap distribution of the likelihood ratio LR by the Algorithm 1 using the mean
}
