% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{dwBS}
\alias{dwBS}
\title{Dependent wild bootstrap for resampling time series}
\usage{
dwBS(y)
}
\arguments{
\item{y}{A \eqn{T\times 1} vector of time series to be resampled.}
}
\value{
A \eqn{T\times 1} matrix of resampled time series.
}
\description{
Select an optimal bandwidth parameter and apply the dependent wild bootstrap
with Bartlett kernel to obtain the resampled time series.
}
\examples{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
G_star <- dwBS(est_multi$G)
}
\references{
Shao, X., 2010. The dependent wild bootstrap. Journal of the
American Statistical Association, 105(489), pp.218-235.
}
