% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust.R
\name{gforce.hclust}
\alias{gforce.hclust}
\title{Hierarchical Clustering with Estimation of \eqn{K}.}
\usage{
gforce.hclust(X = NULL, dists = NULL, R_only = FALSE)
}
\arguments{
\item{X}{\eqn{n x m} matrix. Each row is treated as a point in \eqn{R^m}.}

\item{dists}{\eqn{n x n} symmetric matrix. This encodes the distances between the \eqn{n} points.}

\item{R_only}{logical expression. If \code{R_only == FALSE}, then the included
native code implementation will be used. Otherwise, an R implementation is used.}
}
\value{
Returns an object with the components:
\describe{
\item{\code{K}}{an estimate of the number of clusters.}
\item{\code{clusters}}{a \eqn{n} dimensional integer vector. Entry \eqn{i} to the cluster assignment of the data point given by row \eqn{i} of \code{X}.}
\item{\code{MSE}}{a \eqn{n} dimensional vector of the mean squared errors of each choice of \eqn{K}.}
}
}
\description{
Clusters \eqn{n} points of dimension \eqn{m} using a complete linkage algorithm and estimates \eqn{K}.
}
\examples{
m <- 10 
n <- 10
X <- matrix(MASS::mvrnorm(m*n,rep(0,m*n),diag(m*n)), nrow = n)
hc_res <- gforce.hclust(X=X)

}
\references{
D. Defays. An efficient algorithm for a complete link method. \emph{The Computer Journal}, 1977.
}
