% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.ggmncv.R
\name{coef.ggmncv}
\alias{coef.ggmncv}
\title{Regression Coefficients from \code{ggmncv} Objects}
\usage{
\method{coef}{ggmncv}(object, ...)
}
\arguments{
\item{object}{An Object of classs \code{ggmncv}}

\item{...}{Currently ignored}
}
\value{
A matrix of regression coefficients
}
\description{
Regression Coefficients from \code{ggmncv} Objects
}
\note{
The matrix of coefficients can be accessed by removing the class
from the returned object (e.g., \code{unclass(coefs)}).
}
\examples{

\donttest{

# data
Y <- GGMncv::ptsd

# correlations
S <- cor(Y)

# fit model
fit <- ggmncv(S, n = nrow(Y))

coefs <- coef(fit)

}
}
