% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnostic.R
\name{fn_switch}
\alias{fn_switch}
\title{Function switch}
\usage{
fn_switch(types, mapping_val = "y")
}
\arguments{
\item{types}{list of functions that follow the ggmatrix function standard: \code{function(data, mapping, ...){ #make ggplot2 object }}.  One key should be a 'default' key for a default switch case.}

\item{mapping_val}{mapping value to switch on.  Defautls to the 'y' varaible of the aesthetics list.}
}
\description{
Function that allows you to call different functions based upon an aesthetic variable value.
}
\examples{
ggnostic_continuous_fn <- fn_switch(list(
  default = ggally_points,
  .fitted = ggally_points,
  .se.fit = ggally_nostic_se_fit,
  .resid = ggally_nostic_resid,
  .hat = ggally_nostic_hat,
  .sigma = ggally_nostic_sigma,
  .cooksd = ggally_nostic_cooksd,
  .std.resid = ggally_nostic_std_resid
))

ggnostic_combo_fn <- fn_switch(list(
  default = ggally_box_no_facet,
  fitted = ggally_box_no_facet,
  .se.fit = ggally_nostic_se_fit,
  .resid = ggally_nostic_resid,
  .hat = ggally_nostic_hat,
  .sigma = ggally_nostic_sigma,
  .cooksd = ggally_nostic_cooksd,
  .std.resid = ggally_nostic_std_resid
))
}

