% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downsample_dztd.R
\name{d.ztd.resample}
\alias{d.ztd.resample}
\title{Resample Di-ZTD to phase cell resolution and match raster extents.}
\usage{
d.ztd.resample(unw_pha, dztd, method = "bilinear")
}
\arguments{
\item{unw_pha}{Un-wrapped InSAR tile/raster.}

\item{dztd}{Di-ZTD.}

\item{method}{Raster resampleing method "ngb" for nearest neighbor or "bilinear" for bilinear interpolation}
}
\description{
Resample Di-ZTD to phase cell resolution and match raster extents.
}
\examples{
library(raster)
library(GInSARCorW)
library(circular)
noDataAsNA<-FALSE
i1m<-system.file("td","20170317.ztd.rsc",package = "GInSARCorW")
i2m<-system.file("td","20170410.ztd.rsc",package = "GInSARCorW")
GACOS_ZTD_T1<-GACOS.Import(i1m,noDataAsNA)
GACOS_ZTD_T2<-GACOS.Import(i2m,noDataAsNA)
dztd<-d.ztd(GACOS_ZTD_T1,GACOS_ZTD_T2)
unw_pha<-raster(system.file("td","Unw_Phase_ifg_17Mar2017_10Apr2017_VV.img",package = "GInSARCorW"))
crs(unw_pha)<-CRS("+proj=longlat +datum=WGS84 +no_defs")
d.ztd.resample(unw_pha,dztd)
}
\author{
Subhadip Datta
}
