% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpfr.functions6.R
\name{mat2fd}
\alias{mat2fd}
\title{Create an 'fd' object from a matrix}
\usage{
mat2fd(mat, fdList = NULL)
}
\arguments{
\item{mat}{Input data, should be a matrix with ncol time points and nrow
replications or samples.}

\item{fdList}{A list with following items: \describe{ \item{time}{Sequence
of time points (default to be 100 points from 0 to 1).}
\item{nbasis}{Number of basis functions used in smoothing, default to be
less or equal to 23.} \item{norder}{Order of the functional curves default
to be 6.} \item{bSpline}{Logical, if TRUE (default), b-Spline basis is
used; otherwise, Fourier basis is used.} \item{Pen}{Default to be c(0,0),
meaning that the penalty is on the second order derivative of the curve,
since the weight for zero-th and first order derivatives of the curve are
set to zero.} \item{lambda}{Smoothing parameter for the penalty. Default to
be 1e-4.} }}
}
\value{
An 'fd' object
}
\description{
Easy setting up for creating an 'fd' object
}
\details{
All items listed above have default values. If any item is required
  to change, add that item into the list; otherwise, leave it as NULL. For
  example, if one only wants to change the number of basis functions, do:
  \code{mat2fd(SomeMatrix,list(nbasis=21))}
}
\examples{
require(fda)
ry <- rnorm(20, sd=10)
y1 <- matrix(NA, ncol=100, nrow=20)
for(i in 1:20)  y1[i,] <- sin(seq(-1,pi,len=100))*ry[i]

y1fd <- mat2fd(y1)
y1fd <- mat2fd(y1,list(lambda=1))
}
\references{
Shi, J. Q., and Choi, T. (2011), ``Gaussian Process Regression
  Analysis for Functional Data'', CRC Press.
}
