% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_prediction.R
\name{vecchia_lincomb}
\alias{vecchia_lincomb}
\title{linear combination of predictions
compute the distribution of a linear combination Hy}
\usage{
vecchia_lincomb(H, U.obj, V.ord, cov.mat = FALSE)
}
\arguments{
\item{H}{sparse matrix with n.all columns specifying the linear combination}

\item{U.obj}{U matrix is the full joint approximated cholesky matrix}

\item{V.ord}{ordered V matrix from vecchia_prediction() or U2V()}

\item{cov.mat}{logical TRUE or FALSE -- should the entire covariance matrix be returned (only do if H has a small number of rows)}
}
\value{
Variance of linear combination of predictions.
}
\description{
linear combination of predictions
compute the distribution of a linear combination Hy
}
\examples{
n=5; z=rnorm(n); locs=matrix(1:n,ncol=1); n.p=5
vecchia.approx = vecchia_specify(locs,m=3,locs.pred=locs+.5)
preds=vecchia_prediction(z,vecchia.approx,covparms=c(1,2,.5),nuggets=.2)
H=Matrix::sparseMatrix(i=rep(1,n.p),j=n+(1:n.p),x=1/n.p)
vecchia_lincomb(H,vecchia.approx,preds$V.ord,cov.mat=TRUE)
}
