% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_fastq.R
\name{trim_fastq}
\alias{trim_fastq}
\title{Trim fastq files using Trimmomatic}
\usage{
trim_fastq(srr_id, fastq_dir, instrument, trimmomatic_path,
  library_layout = c("SINGLE", "PAIRED"), destdir, n_thread)
}
\arguments{
\item{srr_id}{SRA run accession ID.}

\item{fastq_dir}{directory of the fastq files.}

\item{instrument}{name of the illumina sequencing platform.
For example, \code{'HiSeq'}.}

\item{trimmomatic_path}{path to the Trimmomatic software.}

\item{library_layout}{layout of the library used. Either \code{'SINGLE'}
or \code{'PAIRED'}.}

\item{destdir}{directory where the trimmed fastq files will be saved.}

\item{n_thread}{number of cores.}
}
\value{
trimmed fastq files.
}
\description{
\code{trim_fastq} trim fastq files based on the illumina instruments
using Trimmomatic.
}
\details{
The following parameters are used as default in the trimmoatic function:
\enumerate{
\item Remove leading low quality or N bases (below quality 3) 
(LEADING:3)
\item Remove trailing low quality or N bases (below quality 3) 
(TRAILING:3)
\item Scan the read with a 4-base wide sliding window, cutting when
the average quality per base drops below 15 (SLIDINGWINDOW:4:15)
\item Drop reads below the 36 bases long (MINLEN:36)
}
}
\examples{

\donttest{
fastq_dir=system.file("extdata","", package="GREP2")
trimmomatic_path=system.file("java","trimmomatic-0.36.jar", package="GREP2")
trim_fastq(srr_id="SRR5890521",fastq_dir=fastq_dir,
instrument="MiSeq",trimmomatic_path=trimmomatic_path,
library_layout="SINGLE",destdir=tempdir(),n_thread=2)
}

}
\references{
Anthony M. Bolger, Marc Lohse, and Bjoern Usadel (2014):
Trimmomatic: a flexible trimmer for Illumina sequence data.
Bioinformatics, 30(15), 2114-2120.
\url{https://doi.org/10.1093/bioinformatics/btu170}
}
