% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noisy_dataset.R
\name{createNoisyDataset}
\alias{createNoisyDataset}
\title{Noisy Data Set Constructor}
\usage{
createNoisyDataset(name, genotypes = NULL, covariance = NULL,
  phenotypes, strata = NULL, extraCovariates = NULL, ploidy = 2,
  noiseInjector = noiseInjector.dummy, ...)
}
\arguments{
\item{name}{A string defining the dataset name, used later do identify this
particular instance in reports and result files. It is advisable for
it to be it somewhat meaningful (to you, GROAN simply reports it as it is)}

\item{genotypes}{Matrix or dataframe containing SNP genotypes, one row per sample (N), one column per marker (M), 0/1/2 format (for diploids)
or 0/1/2.../ploidy in case of polyploids}

\item{covariance}{matrix of covariances between samples of this dataset. It is usually a square (NxN) matrix,
but rectangular matrices (NxW) are accepted to incapsulate covariances between samples in
this set and samples of other sets. Please note that some regression models expect the
covariance to be square and will fail on rectangular ones}

\item{phenotypes}{numeric array, N slots}

\item{strata}{array of M slots, describing the strata each data point belongs to. This is
used for stratified crossvalidation (see \code{\link{createWorkbench}})}

\item{extraCovariates}{dataframe of optional extra covariates (N lines, one column per extra covariate).
Numeric ones will be normalized, string and categorical ones will be transformed
in stub TRUE/FALSE variables (one per possible value, see \link[stats]{model.matrix}).}

\item{ploidy}{number of haploid sets in the cell. Defaults to 2 (diploid).}

\item{noiseInjector}{name of a noise injector function, defaults to \link{noiseInjector.dummy}}

\item{...}{further arguments are passed along to noiseInjector}
}
\value{
a GROAN.NoisyDataset object.
}
\description{
This function creates a GROAN.NoisyDataset object (or fails trying). The
class will contain all noisy data set components: genotypes and/or covariance matrix,
phenotypes, strata (optional), a noise injector function and its parameters.\cr
You can have a general description of the created object using the overridden \link{print.GROAN.NoisyDataset}
function.
}
\examples{
#For more complete examples see the package vignette
#creating a noisy dataset with normal noise
nds = createNoisyDataset(
  name = 'PEA, normal noise',
  genotypes = GROAN.KI$SNPs,
  phenotypes = GROAN.KI$yield,
  noiseInjector = noiseInjector.norm,
  mean = 0,
  sd = sd(GROAN.KI$yield) * 0.5
)
}
\seealso{
\link{GROAN.run} \link{createWorkbench}
}
