% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressors.R
\name{phenoRegressor.BGLR}
\alias{phenoRegressor.BGLR}
\title{Regression using BGLR package}
\usage{
phenoRegressor.BGLR(phenotypes, genotypes, covariances, extraCovariates,
  type = c("FIXED", "BRR", "BL", "BayesA", "BayesB", "BayesC", "RKHS"),
  ...)
}
\arguments{
\item{phenotypes}{phenotypes, a numeric array (n x 1), missing values are predicted}

\item{genotypes}{SNP genotypes, one row per phenotype (n), one column per marker (m), values in 0/1/2 for
diploids or 0/1/2/...ploidy for polyploids. Can be NULL if \code{covariances} is present.}

\item{covariances}{square matrix (n x n) of covariances. Can be NULL if \code{genotypes} is present.}

\item{extraCovariates}{extra covariates set, one row per phenotype (n), one column per covariate (w).
If NULL no extra covariates are considered.}

\item{type}{character literal, one of the following: FIXED (Flat prior), BRR (Gaussian prior),
BL (Double-Exponential prior), BayesA (scaled-t prior),
BayesB (two component mixture prior with a point of mass at zero and a scaled-t slab),
BayesC (two component mixture prior with a point of mass at zero and a Gaussian slab)}

\item{...}{extra parameters are passed to \code{\link[BGLR]{BGLR}}}
}
\value{
The function returns a list with the following fields:
\itemize{
  \item \code{predictions} : an array of (n) predicted phenotypes, with NAs filled and all other positions repredicted (useful for calculating residuals)
  \item \code{hyperparams} : empty, returned for compatibility
  \item \code{extradata}   : list with information on trained model, coming from \code{\link[BGLR]{BGLR}}
}
}
\description{
This is a wrapper around \code{\link[BGLR]{BGLR}}. As such, it won't work if BGLR package
is not installed.\cr
Genotypes are modeled using the specified \code{type}. If \code{type} is 'RKHS' (and only
in this case) the covariance/kinship matrix \code{covariances} is required, and it will be modeled
as matrix K in BGLR terms. In all other cases genotypes and covariances are put in the model
as X matrices.\cr
Extra covariates, if present, are modeled as FIXED effects.
}
\examples{
\dontrun{
#using the GROAN.KI dataset, we regress on the dataset and predict the first ten phenotypes
phenos = GROAN.KI$yield
phenos[1:10]  = NA

#calling the regressor with Bayesian Lasso
results = phenoRegressor.BGLR(
  phenotypes = phenos,
  genotypes = GROAN.KI$SNPs,
  covariances = NULL,
  extraCovariates = NULL,
  type = 'BL', nIter = 2000 #BGLR-specific parameters
)

#examining the predictions
plot(GROAN.KI$yield, results$predictions,
     main = 'Train set (black) and test set (red) regressions',
     xlab = 'Original phenotypes', ylab = 'Predicted phenotypes')
points(GROAN.KI$yield[1:10], results$predictions[1:10], pch=16, col='red')

#printing correlations
test.set.correlation  = cor(GROAN.KI$yield[1:10], results$predictions[1:10])
train.set.correlation = cor(GROAN.KI$yield[-(1:10)], results$predictions[-(1:10)])
writeLines(paste(
  'test-set correlation :', test.set.correlation,
  '\\ntrain-set correlation:', train.set.correlation
))
}
}
\seealso{
\link[BGLR]{BGLR}

Other phenoRegressors: \code{\link{phenoRegressor.RFR}},
  \code{\link{phenoRegressor.SVR}},
  \code{\link{phenoRegressor.dummy}},
  \code{\link{phenoRegressor.rrBLUP}}
}
\concept{phenoRegressors}
