% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASinspector.R
\docType{package}
\name{GWASinspector}
\alias{GWASinspector}
\alias{GWASinspector-package}
\title{Comprehensive and Easy to Use Quality Control of GWAS Results}
\description{
When evaluating the results of a genome-wide association study (GWAS), it is important to perform a quality control to ensure that the results are valid, complete, correctly formatted, and, in case of meta-analysis, consistent with other studies in the same analysis.
This package was developed to facilitate and streamline this process and provide the user with a comprehensive report.
}
\details{
Check out our website for more help and support  \url{http://GWASinspector.com}.
}
\note{
GWASinspector uses the S4 object system of R to conduct the QC.
The QC is configured using an ini file (check \code{\link{get.config}}), which is imported into R through \code{\link{setup.inspector}} and
turned into an object of the \linkS4class{Inspector} class. To perform the QC, process the object with \code{\link{run.inspector}}.
A quick scan of the results can be performed via \code{\link{result.inspector}}, but the primary outcome of the QC are the
log files and graphs generated by \code{\link{run.inspector}}.

The main product of the QC is the extensive log file (in Excel/HTML format, depending on your settings)
}
\section{Functions}{


\code{\link{setup.inspector}} This function Imports a QC-configuration file into R by generating a new instance of \linkS4class{Inspector} class.

\code{\link{run.inspector}} This is the main function for running the algorithm on a list of GWAS result files.

\code{\link{result.inspector}} This function displays a brief report about the results of running the Inspector algorithm on a list of GWAS result files.

\code{\link{sample.inspector}} This function runs the algorithm on a fabricated GWAS result file. User should only set the output folder for saving the generated files. The input file and reference dataset are embedded in the package.

\code{\link{sqlite.db.check}} Displays the summary of a reference database, including how many tables are in the database file, number of data rows for each data table and the first row of each table

\code{\link{system.check}} Checks if required and optional packages are installed on the system. Although the optional packages do not contribute to the QC itself, having them available will allow for Excel and HTML formatted log files, which are easier to read and interpret.

\code{\link{get.config}} Save a sample configuration file on your computer.

\code{\link{get.headerTranslation}} Save a sample column header translation table file.

\code{\link{compare.GWASs}} Compares result files from different analyses. So, there is no need to re-run the analysis on a result file again.

\code{\link{man.plot}} Generates the Manhattan plot from a result file. This function has many features that are described in the package tutorial.
}

