% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossValidate.R
\name{CrossValidate}
\alias{CrossValidate}
\title{Cross-validated predictions for a \code{GaSPModel} object.}
\usage{
CrossValidate(GaSP_model)
}
\arguments{
\item{GaSP_model}{Object of class \code{\link{GaSPModel}}.}
}
\value{
A data frame with two columns: the cross-validated predictions
\code{Pred} and their standard errors \code{SE}.
}
\description{
Compute leave-one-out cross-validated predictions for a \code{GaSPModel} object.
}
\note{
\code{\link{RMSE}} computes the root mean squared error
of the predictions.
\code{\link{PlotPredictions}} and \code{\link{PlotResiduals}}
plot the predictions or their residuals;
\code{\link{PlotStdResiduals}} and \code{\link{PlotQQ}}
plot the stanadardized residuals.
}
\examples{
\dontshow{
x <- borehole$x
y <- borehole$y
theta <- c(
  5.767699e+01, 0.000000e+00, 0.000000e+00, 1.433571e-06,
  0.000000e+00, 2.366557e-06, 1.695619e-07, 2.454376e-09
)
alpha <- c(
  1.110223e-16, 0.000000e+00, 0.000000e+00, 0.000000e+00,
  0.000000e+00, 0.000000e+00, 2.494862e-03, 0.000000e+00
)
cor_par <- data.frame(Theta = theta, Alpha = alpha)
rownames(cor_par) <- colnames(borehole$x)
sp_var <- 38783.7
borehole_fit <- GaSPModel(
  x = borehole$x, y = borehole$y,
  reg_model = ~1, cor_family = "PowerExponential",
  cor_par = cor_par, random_error = FALSE,
  sp_var = sp_var
)
}
borehole_cv <- CrossValidate(borehole_fit)
}
