% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRSex.R
\name{GRSex}
\alias{GRSex}
\title{Geographical representativeness score ex situ}
\usage{
GRSex(
  Species_list,
  Occurrence_data,
  Raster_list,
  Buffer_distance = 50000,
  Gap_Map = FALSE
)
}
\arguments{
\item{Species_list}{A vector of characters with the species names to calculate the GRSex metrics.}

\item{Occurrence_data}{A data frame object with the species name, geographical coordinates,
and type of records (G or H) for a given species}

\item{Raster_list}{A list of rasters representing the species distribution models for the species list provided
in \var{Species_list}. The order of rasters in this list must match the same order as \var{Species_list}.}

\item{Buffer_distance}{Geographical distance used to create circular buffers around germplasm.
Default: 50000 (50 km) around germplasm accessions (CA50)}

\item{Gap_Map}{logical, if \code{TRUE} the function will calculate gap maps for each species analyzed and
will return a list with two slots GRSex and gap_maps. If any value is provided, the function will assume that
Gap_Map = TRUE}
}
\value{
This function returns a data frame with two columns:

\tabular{lcc}{
species \tab Species name \cr
GRSex \tab GRSex value calculated\cr
}
}
\description{
The GRSex process provides a geographic measurement of the proportion of a species’ range
 that can be considered to be conserved in ex situ repositories. The GRSex uses buffers (default 50 km radius)
 created around each G coordinate point to estimate geographic areas already well collected within the distribution
 models of each taxon, and then calculates the proportion of the distribution model covered by these buffers.
}
\examples{
##Obtaining occurrences from example
data(CucurbitaData)
Cucurbita_splist <- unique(CucurbitaData$species)
## Obtaining rasterList object. ##
data(CucurbitaRasters)
CucurbitaRasters <- raster::unstack(CucurbitaRasters)
#Running GRSex
GRSex_df <- GRSex(Species_list = Cucurbita_splist,
                    Occurrence_data = CucurbitaData,
                    Raster_list = CucurbitaRasters,
                    Buffer_distance = 50000,
                    Gap_Map = TRUE)

}
\references{
Ramirez-Villegas et al. (2010) PLOS ONE, 5(10), e13497. doi: 10.1371/journal.pone.0013497
Khoury et al. (2019) Ecological Indicators 98:420-429. doi: 10.1016/j.ecolind.2018.11.016
}
