% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_constant.R
\docType{class}
\name{trend_c}
\alias{trend_c}
\title{Trend R6 class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Trend R6 class

Trend R6 class
}
\examples{
t1 <- trend_c$new()
}
\section{Super class}{
\code{\link[GauPro:GauPro_trend]{GauPro::GauPro_trend}} -> \code{GauPro_trend_c}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{m}}{Trend parameters}

\item{\code{m_lower}}{m lower bound}

\item{\code{m_upper}}{m upper bound}

\item{\code{m_est}}{Should m be estimated?}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_trend_c-new}{\code{trend_c$new()}}
\item \href{#method-GauPro_trend_c-Z}{\code{trend_c$Z()}}
\item \href{#method-GauPro_trend_c-dZ_dparams}{\code{trend_c$dZ_dparams()}}
\item \href{#method-GauPro_trend_c-dZ_dx}{\code{trend_c$dZ_dx()}}
\item \href{#method-GauPro_trend_c-param_optim_start}{\code{trend_c$param_optim_start()}}
\item \href{#method-GauPro_trend_c-param_optim_start0}{\code{trend_c$param_optim_start0()}}
\item \href{#method-GauPro_trend_c-param_optim_lower}{\code{trend_c$param_optim_lower()}}
\item \href{#method-GauPro_trend_c-param_optim_upper}{\code{trend_c$param_optim_upper()}}
\item \href{#method-GauPro_trend_c-set_params_from_optim}{\code{trend_c$set_params_from_optim()}}
\item \href{#method-GauPro_trend_c-clone}{\code{trend_c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-new"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-new}{}}}
\subsection{Method \code{new()}}{
Initialize trend object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$new(m = 0, m_lower = -Inf, m_upper = Inf, m_est = TRUE, D = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m}}{trend initial parameters}

\item{\code{m_lower}}{trend lower bounds}

\item{\code{m_upper}}{trend upper bounds}

\item{\code{m_est}}{Logical of whether each param should be estimated}

\item{\code{D}}{Number of input dimensions of data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-Z"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-Z}{}}}
\subsection{Method \code{Z()}}{
Get trend value for given matrix X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$Z(X, m = self$m, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{matrix of points}

\item{\code{m}}{trend parameters}

\item{\code{params}}{trend parameters}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-dZ_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-dZ_dparams}{}}}
\subsection{Method \code{dZ_dparams()}}{
Derivative of trend with respect to trend parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$dZ_dparams(X, m = self$m, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{matrix of points}

\item{\code{m}}{trend values}

\item{\code{params}}{overrides m}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-dZ_dx"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-dZ_dx}{}}}
\subsection{Method \code{dZ_dx()}}{
Derivative of trend with respect to X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$dZ_dx(X, m = self$m, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{matrix of points}

\item{\code{m}}{trend values}

\item{\code{params}}{overrides m}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-param_optim_start"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-param_optim_start}{}}}
\subsection{Method \code{param_optim_start()}}{
Get parameter initial point for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$param_optim_start(jitter = F, m_est = self$m_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Not used}

\item{\code{m_est}}{If the trend should be estimate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-param_optim_start0"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-param_optim_start0}{}}}
\subsection{Method \code{param_optim_start0()}}{
Get parameter initial point for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$param_optim_start0(jitter = F, m_est = self$m_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{jitter}}{Not used}

\item{\code{m_est}}{If the trend should be estimate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-param_optim_lower"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-param_optim_lower}{}}}
\subsection{Method \code{param_optim_lower()}}{
Get parameter lower bounds for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$param_optim_lower(m_est = self$m_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m_est}}{If the trend should be estimate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-param_optim_upper"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-param_optim_upper}{}}}
\subsection{Method \code{param_optim_upper()}}{
Get parameter upper bounds for optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$param_optim_upper(m_est = self$m_est)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m_est}}{If the trend should be estimate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-set_params_from_optim"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-set_params_from_optim}{}}}
\subsection{Method \code{set_params_from_optim()}}{
Set parameters after optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$set_params_from_optim(optim_out)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optim_out}}{Output from optim}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_trend_c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_trend_c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trend_c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
