% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_Matern32.R
\docType{class}
\name{Matern32}
\alias{Matern32}
\alias{k_Matern32}
\title{Matern 3/2 Kernel R6 class}
\format{
\code{\link[R6]{R6Class}} object.
}
\usage{
k_Matern32(
  beta,
  s2 = 1,
  D,
  beta_lower = -8,
  beta_upper = 6,
  beta_est = TRUE,
  s2_lower = 1e-08,
  s2_upper = 1e+08,
  s2_est = TRUE,
  useC = TRUE
)
}
\arguments{
\item{beta}{Initial beta value}

\item{s2}{Initial variance}

\item{D}{Number of input dimensions of data}

\item{beta_lower}{Lower bound for beta}

\item{beta_upper}{Upper bound for beta}

\item{beta_est}{Should beta be estimated?}

\item{s2_lower}{Lower bound for s2}

\item{s2_upper}{Upper bound for s2}

\item{s2_est}{Should s2 be estimated?}

\item{useC}{Should C code used? Much faster.}
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for fitting GP model.
}
\description{
Matern 3/2 Kernel R6 class

Matern 3/2 Kernel R6 class
}
\examples{
k1 <- Matern32$new(beta=0)
plot(k1)

n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro_kernel_model$new(X=x, Z=y, kernel=Matern32$new(1),
                              parallel=FALSE)
gp$predict(.454)
gp$plot1D()
gp$cool1Dplot()
}
\section{Super classes}{
\code{\link[GauPro:GauPro_kernel]{GauPro::GauPro_kernel}} -> \code{\link[GauPro:GauPro_kernel_beta]{GauPro::GauPro_kernel_beta}} -> \code{GauPro_kernel_Matern32}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sqrt3}}{Saved value of square root of 3}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_kernel_Matern32-k}{\code{Matern32$k()}}
\item \href{#method-GauPro_kernel_Matern32-kone}{\code{Matern32$kone()}}
\item \href{#method-GauPro_kernel_Matern32-dC_dparams}{\code{Matern32$dC_dparams()}}
\item \href{#method-GauPro_kernel_Matern32-dC_dx}{\code{Matern32$dC_dx()}}
\item \href{#method-GauPro_kernel_Matern32-print}{\code{Matern32$print()}}
\item \href{#method-GauPro_kernel_Matern32-clone}{\code{Matern32$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel" data-id="plot"><a href='../../GauPro/html/GauPro_kernel.html#method-GauPro_kernel-plot'><code>GauPro::GauPro_kernel$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="C_dC_dparams"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-C_dC_dparams'><code>GauPro::GauPro_kernel_beta$C_dC_dparams()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="initialize"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-initialize'><code>GauPro::GauPro_kernel_beta$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_lower"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_lower'><code>GauPro::GauPro_kernel_beta$param_optim_lower()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_start"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_start'><code>GauPro::GauPro_kernel_beta$param_optim_start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_start0"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_start0'><code>GauPro::GauPro_kernel_beta$param_optim_start0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_upper"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_upper'><code>GauPro::GauPro_kernel_beta$param_optim_upper()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="s2_from_params"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-s2_from_params'><code>GauPro::GauPro_kernel_beta$s2_from_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="set_params_from_optim"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-set_params_from_optim'><code>GauPro::GauPro_kernel_beta$set_params_from_optim()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Matern32-k"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Matern32-k}{}}}
\subsection{Method \code{k()}}{
Calculate covariance between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Matern32$k(x, y = NULL, beta = self$beta, s2 = self$s2, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector.}

\item{\code{y}}{vector, optional. If excluded, find correlation
of x with itself.}

\item{\code{beta}}{Correlation parameters.}

\item{\code{s2}}{Variance parameter.}

\item{\code{params}}{parameters to use instead of beta and s2.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Matern32-kone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Matern32-kone}{}}}
\subsection{Method \code{kone()}}{
Find covariance of two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Matern32$kone(x, y, beta, theta, s2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector}

\item{\code{y}}{vector}

\item{\code{beta}}{correlation parameters on log scale}

\item{\code{theta}}{correlation parameters on regular scale}

\item{\code{s2}}{Variance parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Matern32-dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Matern32-dC_dparams}{}}}
\subsection{Method \code{dC_dparams()}}{
Derivative of covariance with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Matern32$dC_dparams(params = NULL, X, C_nonug, C, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{X}}{matrix of points in rows}

\item{\code{C_nonug}}{Covariance without nugget added to diagonal}

\item{\code{C}}{Covariance with nugget}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Matern32-dC_dx"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Matern32-dC_dx}{}}}
\subsection{Method \code{dC_dx()}}{
Derivative of covariance with respect to X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Matern32$dC_dx(XX, X, theta, beta = self$beta, s2 = self$s2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{matrix of points}

\item{\code{X}}{matrix of points to take derivative with respect to}

\item{\code{theta}}{Correlation parameters}

\item{\code{beta}}{log of theta}

\item{\code{s2}}{Variance parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Matern32-print"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Matern32-print}{}}}
\subsection{Method \code{print()}}{
Print this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Matern32$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Matern32-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Matern32-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Matern32$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
