% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_Triangle.R
\docType{class}
\name{Triangle}
\alias{Triangle}
\title{Triangle Kernel R6 class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Triangle Kernel R6 class

Triangle Kernel R6 class
}
\examples{
k1 <- Triangle$new(beta=0)
plot(k1)

n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro_kernel_model$new(X=x, Z=y, kernel=Triangle$new(1),
                              parallel=FALSE)
gp$predict(.454)
gp$plot1D()
gp$cool1Dplot()
}
\section{Super classes}{
\code{\link[GauPro:GauPro_kernel]{GauPro::GauPro_kernel}} -> \code{\link[GauPro:GauPro_kernel_beta]{GauPro::GauPro_kernel_beta}} -> \code{GauPro_kernel_Triangle}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GauPro_kernel_Triangle-k}{\code{Triangle$k()}}
\item \href{#method-GauPro_kernel_Triangle-kone}{\code{Triangle$kone()}}
\item \href{#method-GauPro_kernel_Triangle-dC_dparams}{\code{Triangle$dC_dparams()}}
\item \href{#method-GauPro_kernel_Triangle-dC_dx}{\code{Triangle$dC_dx()}}
\item \href{#method-GauPro_kernel_Triangle-print}{\code{Triangle$print()}}
\item \href{#method-GauPro_kernel_Triangle-clone}{\code{Triangle$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel" data-id="plot"><a href='../../GauPro/html/GauPro_kernel.html#method-GauPro_kernel-plot'><code>GauPro::GauPro_kernel$plot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="C_dC_dparams"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-C_dC_dparams'><code>GauPro::GauPro_kernel_beta$C_dC_dparams()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="initialize"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-initialize'><code>GauPro::GauPro_kernel_beta$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_lower"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_lower'><code>GauPro::GauPro_kernel_beta$param_optim_lower()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_start"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_start'><code>GauPro::GauPro_kernel_beta$param_optim_start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_start0"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_start0'><code>GauPro::GauPro_kernel_beta$param_optim_start0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="param_optim_upper"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-param_optim_upper'><code>GauPro::GauPro_kernel_beta$param_optim_upper()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="s2_from_params"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-s2_from_params'><code>GauPro::GauPro_kernel_beta$s2_from_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_kernel_beta" data-id="set_params_from_optim"><a href='../../GauPro/html/GauPro_kernel_beta.html#method-GauPro_kernel_beta-set_params_from_optim'><code>GauPro::GauPro_kernel_beta$set_params_from_optim()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Triangle-k"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Triangle-k}{}}}
\subsection{Method \code{k()}}{
Calculate covariance between two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$k(x, y = NULL, beta = self$beta, s2 = self$s2, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector.}

\item{\code{y}}{vector, optional. If excluded, find correlation
of x with itself.}

\item{\code{beta}}{Correlation parameters.}

\item{\code{s2}}{Variance parameter.}

\item{\code{params}}{parameters to use instead of beta and s2.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Triangle-kone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Triangle-kone}{}}}
\subsection{Method \code{kone()}}{
Find covariance of two points
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$kone(x, y, beta, theta, s2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector}

\item{\code{y}}{vector}

\item{\code{beta}}{correlation parameters on log scale}

\item{\code{theta}}{correlation parameters on regular scale}

\item{\code{s2}}{Variance parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Triangle-dC_dparams"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Triangle-dC_dparams}{}}}
\subsection{Method \code{dC_dparams()}}{
Derivative of covariance with respect to parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$dC_dparams(params = NULL, X, C_nonug, C, nug)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{Kernel parameters}

\item{\code{X}}{matrix of points in rows}

\item{\code{C_nonug}}{Covariance without nugget added to diagonal}

\item{\code{C}}{Covariance with nugget}

\item{\code{nug}}{Value of nugget}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Triangle-dC_dx"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Triangle-dC_dx}{}}}
\subsection{Method \code{dC_dx()}}{
Derivative of covariance with respect to X
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$dC_dx(XX, X, theta, beta = self$beta, s2 = self$s2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{XX}}{matrix of points}

\item{\code{X}}{matrix of points to take derivative with respect to}

\item{\code{theta}}{Correlation parameters}

\item{\code{beta}}{log of theta}

\item{\code{s2}}{Variance parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Triangle-print"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Triangle-print}{}}}
\subsection{Method \code{print()}}{
Print this object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GauPro_kernel_Triangle-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GauPro_kernel_Triangle-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Triangle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
