% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.convert.R
\name{chat.convert}
\alias{chat.convert}
\title{Convert chat history from one Generative AI model to another}
\usage{
chat.convert(source.model.parameter, source.history, target.model.parameter)
}
\arguments{
\item{source.model.parameter}{A character vector containing essential information about the
source Generative AI service provider, model, version, API key, and proxy status.}

\item{source.history}{A list containing all messages exchanged between the user and the model
in a chat session.}

\item{target.model.parameter}{A character vector containing essential information about the
target Generative AI service provider, model, version, API key, and proxy status.}
}
\value{
If the conversion is successful, the function returns the transformed chat history in list format.
In case of incorrect input formats, the function halts execution and provides an error message.
}
\description{
This function transforms the chat history from one Generative AI model to another,
ensuring compatibility and usability across different models.
}
\details{
Providing accurate and valid information for each parameter is crucial for successful
text generation by the Generative AI model. This function modifies the chat history accordingly.
Incorrect parameters will result in an error message based on the API feedback.
To explore supported Generative AI models, use the function \code{available.models}.
Additionally, utilize \code{chat.setup} to set up a chat history.
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 # Setup an empty chat history
 google.history = chat.setup(google.model)
 openai.history = chat.setup(openai.model)

 # Start chat
 temperature = 0.9
 prompt = "Write a story about a magic backpack in about 100 words."
 google.history = chat(google.model,
                       temperature,
                       google.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(google.model, google.history))

 openai.history = chat(openai.model,
                       temperature,
                       openai.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(openai.model, openai.history))

 prompt = "What is the word count of the story you just wrote?"
 google.history = chat(google.model,
                       temperature,
                       google.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(google.model, google.history))

 openai.history = chat(openai.model,
                       temperature,
                       openai.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(openai.model, openai.history))

 # Convert histories
 converted.google.history = chat.convert(openai.model,
                                         openai.history,
                                         google.model)

 converted.openai.history = chat.convert(google.model,
                                         google.history,
                                         openai.model)

 prompt = "Hello! Could you tell me what you just did?"
 converted.google.history = chat(google.model,
                                 temperature,
                                 converted.google.history,
                                 prompt)
 cat(chat.recent(google.model, converted.google.history))

 converted.openai.history = chat(openai.model,
                                 temperature,
                                 converted.openai.history,
                                 prompt)
 cat(chat.recent(openai.model, converted.openai.history))
}

}
