#' Maize Fst Data
#'
#' Data from 85,388 SNPs on chromosome 6 of a maize, in a selection experiment
#' involving 30 generations of selection for increased number of ears per plant
#' The variables are:
#' \itemize{
#'  \item Chromosome. Chromosome 6, always.
#'  \item Position. SNP position on maize reference version 2.
#'  \item C0Freq. Frequency of minor allele in cycle 0.
#'  \item C30Freq. Frequency of same allele in C30 (not necessarily minor)
#'  \item Fst. Fst value based on C0 and C30 frequencies.
#' }
#'
#' @docType data
#'
#' @usage data(chr6)
#'
#' @format A data frame with 85,388 rows and 5 columns.
#'
#' @references Beissinger et al. (2014) Genetics 196(3):829-840
#' (http://www.ncbi.nlm.nih.gov/pubmed/24381334)
#'
#'
#'
#'
#'
"chr6"
