% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_module.R
\name{sequence_module}
\alias{sequence_module}
\title{create sequence module}
\usage{
sequence_module(
  molecular_data = NA,
  initial_frequencies = NA,
  morgan = 1,
  recombination_rate = NA,
  markers = NA,
  mutation_rate = 0,
  substitution_matrix = matrix(1/4, 4, 4)
)
}
\arguments{
\item{molecular_data}{Genomic data used as input, should be of type
genomeadmixr_data. Either a single dataset is provided, or a list of
multiple genomeadmixr_data objects.}

\item{initial_frequencies}{A vector describing the initial contribution of
each provided input data set to the starting hybrid swarm. By default, equal
frequencies are assumed. If a vector not summing to 1 is provided, the vector
is normalized.}

\item{morgan}{Length of the molecular sequence in Morgan (e.g. the number of
crossovers during meiosis), alternatively, the recombination rate can be
used, see below.}

\item{recombination_rate}{rate in cM / Mbp, used to map recombination to the
markers. If the recombination_rate is not set, the value for Morgan is used,
assuming that the markers included span an entire chromosome.}

\item{markers}{A vector of locations of markers, these markers are
tracked for every generation.}

\item{mutation_rate}{the per base probability of mutation. Default is 0.}

\item{substitution_matrix}{a 4x4 matrix representing the probability of
mutating to another base (where [1/2/3/4] = [a/c/t/g]), conditional on the
event of a mutation happening. Default is the JC69 matrix, with equal
probabilities for all transitions / transversions.}
}
\value{
sequence module object, used as starting point for
simulate_admixture.
}
\description{
creates a sequence module, which contains all relevant
information in order to perform a simulation based on sequence data.
}
