% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_visualization.R
\name{gen_topic_clouds}
\alias{gen_topic_clouds}
\title{Create word cloud for topics}
\usage{
gen_topic_clouds(model_output, n = 50)
}
\arguments{
\item{model_output}{The output from model_topics function}

\item{n}{The number of top terms to include in the word cloud}
}
\value{
A list of ggplot objects, where each element represents a word cloud for a topic.
}
\description{
This function creates a word cloud for each topic.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 30, use_parallel = FALSE)

# Model topics
topic_results <- model_topics(reviews, num_topics = 3, num_terms = 50, english_only = TRUE)

# Generate word clouds for each topic
wordcloud_plots <- gen_topic_clouds(topic_results, n = 20)

# Display the word cloud for the first topic
if (interactive()) {
  print(wordcloud_plots[[1]])
}

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
