% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vecchia_profbeta_loglik}
\alias{vecchia_profbeta_loglik}
\title{Vecchia's approximation to the Gaussian loglikelihood, with profiled 
regression coefficients.}
\usage{
vecchia_profbeta_loglik(covparms, covfun_name, y, X, locs, NNarray)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{See \code{\link{GpGp}} for information about covariance
functions.}

\item{y}{vector of response values}

\item{X}{Design matrix of covariates. Row \code{i} of \code{X} contains
the covariates for the observation at row \code{i} of \code{locs}.}

\item{locs}{matrix of locations. Row \code{i} of \code{locs} specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{NNarray}{A matrix of indices, usually the output from \code{\link{find_ordered_nn}}.
Row \code{i} contains the indices
of the observations that observation \code{i} conditions on. By convention,
the first element of row \code{i} is \code{i}.}
}
\value{
a list containing
\itemize{
 \item \code{loglik}: the loglikelihood
 \item \code{betahat}: profile likelihood estimate of regression coefficients
 \item \code{betainfo}: information matrix for \code{betahat}.
}
The covariance
matrix for \code{$betahat} is the inverse of \code{$betainfo}.
}
\description{
This function returns Vecchia's (1988) approximation to the Gaussian
loglikelihood, profiling out the regression coefficients. 
The approximation modifies the ordered conditional
specification of the joint density; rather than each term in the product
conditioning on all previous observations, each term conditions on
a small subset of previous observations.
}
\examples{
n1 <- 20
n2 <- 20
n <- n1*n2
locs <- as.matrix( expand.grid( (1:n1)/n1, (1:n2)/n2 ) )
X <- cbind(rep(1,n),locs[,2])
covparms <- c(2, 0.2, 0.75, 0)
y <- X \%*\% c(1,2) + fast_Gp_sim(covparms, "matern_isotropic", locs, 50 )
ord <- order_maxmin(locs)
NNarray <- find_ordered_nn(locs,20)
loglik <- vecchia_profbeta_loglik( covparms, "matern_isotropic", y, X, locs, NNarray )
}
