% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_spacetime_categorical}
\alias{matern_spacetime_categorical}
\alias{d_matern_spacetime_categorical}
\title{Space-Time Matern covariance function with random effects for categories}
\usage{
matern_spacetime_categorical(covparms, locs)

d_matern_spacetime_categorical(covparms, locs)
}
\arguments{
\item{covparms}{A vector with covariance parameters
in the form (variance, spatial range, temporal range, smoothness, category, nugget)}

\item{locs}{A matrix with \code{n} rows and \code{d} columns.
Each row of locs gives a point in R^d.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the i,j entry
containing the covariance between observations at \code{locs[i,]} and
\code{locs[j,]}.
}
\description{
From a matrix of locations and covariance parameters of the form
(variance, spatial range, temporal range, smoothness, category, nugget), return the square matrix of
all pairwise covariances.
}
\section{Functions}{
\itemize{
\item \code{d_matern_spacetime_categorical()}: Derivatives of isotropic Matern covariance

}}
\section{Parameterization}{

The covariance parameter vector is (variance, range, smoothness, category, nugget)
= \eqn{(\sigma^2,\alpha_1,\alpha_2,\nu,c^2,\tau^2)}, and the covariance function is parameterized
as
\deqn{ d = ( || x - y ||^2/\alpha_1 + |s-t|^2/\alpha_2^2 )^{1/2} }
\deqn{ M(x,y) = \sigma^2 2^{1-\nu}/\Gamma(\nu) (d)^\nu K_\nu(d) }
(x,s) and (y,t) are the space-time locations of a pair of observations.
The nugget value \eqn{ \sigma^2 \tau^2 } is added to the diagonal of the covariance matrix.
The category variance \eqn{c^2} is added if two observation from same category
NOTE: the nugget is \eqn{ \sigma^2 \tau^2 }, not \eqn{ \tau^2 }.
}

