% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CP_functions_unified.R
\name{CP_MTS}
\alias{CP_MTS}
\title{Estimation of matrix CP-factor model}
\usage{
CP_MTS(
  Y,
  xi = NULL,
  Rank = NULL,
  lag.k = 15,
  lag.ktilde = 10,
  method = c("CP.Direct", "CP.Refined", "CP.Unified")
)
}
\arguments{
\item{Y}{A \eqn{n \times p \times q} data array, where \eqn{n} is the sample size and \eqn{(p,q)}
is the dimension of \eqn{{\bf Y}_t}.}

\item{xi}{A \eqn{n \times 1} vector. If \code{NULL} (the default), then a PCA-based \eqn{\xi_{t}}
is used [See Section 5.1 in Chang et al. (2023)] to calculate the sample auto-covariance matrix
\eqn{\widehat{\bf \Sigma}_{\bf Y, \xi}(k)}.}

\item{Rank}{A list of the rank \eqn{d},\eqn{d_1} and \eqn{d_2}. Default to \code{NULL}.}

\item{lag.k}{Integer. Time lag \eqn{K} is only used in \code{CP.Refined} and \code{CP.Unified} to
calculate the nonnegative definte matrices \eqn{\widehat{\mathbf{M}}_1} and
\eqn{\widehat{\mathbf{M}}_2}: \deqn{\widehat{\mathbf{M}}_1\ =\
  \sum_{k=1}^{K}\widehat{\mathbf{\Sigma}}_{\bf Y, \xi}(k)\widehat{\mathbf{\Sigma}}_{\bf Y, \xi}(k)',
  }, \deqn{\widehat{\mathbf{M}}_2\ =\
  \sum_{k=1}^{K}\widehat{\mathbf{\Sigma}}_{\bf Y, \xi}(k)'\widehat{\mathbf{\Sigma}}_{\bf Y, \xi}(k),
  }
  where \eqn{\widehat{\mathbf{\Sigma}}_{\bf Y, \xi}(k)} is the sample auto-covariance of
  \eqn{ {\bf Y}_t} and \eqn{\xi_t} at lag \eqn{k}.}

\item{lag.ktilde}{Integer. Time lag \eqn{\tilde K} is only used in \code{CP.Unified} to calulate the
nonnegative definte matrix \eqn{\widehat{\mathbf{M}}}: \deqn{\widehat{\mathbf{M}} \ =\
  \sum_{k=1}^{\tilde K}\widehat{\mathbf{\Sigma}}_{\tilde{\bf Z}}(k)\widehat{\mathbf{\Sigma}}_{\tilde{\bf Z}}(k)'.
  }}

\item{method}{Method to use: \code{CP.Direct} and \code{CP.Refined}, Chang et al.(2023)'s direct and refined estimators;
\code{CP.Unified}, Chang et al.(2024+)'s unified estimation procedure.}
}
\value{
An object of class "mtscp" is a list containing the following
  components:
  \item{A}{The estimated \eqn{p \times d} left loading matrix \eqn{\widehat{\bf A}}.}
  \item{B}{The estimated \eqn{q \times d} right loading matrix \eqn{\widehat{\bf B}}.}
  \item{f}{The estimated latent process \eqn{(\hat{x}_{1,t},\ldots,\hat{x}_{d,t})}.}
  \item{Rank}{The estimated rank \eqn{(\hat{d}_1,\hat{d}_2,\hat{d})} of the matrix CP-factor model.}
}
\description{
\code{CP_MTS()} deals with CP-decomposition for high-dimensional
 matrix time series proposed in Chang et al. (2023):\deqn{{\bf{Y}}_t = {\bf A \bf X}_t{\bf B}^{'} +
{\boldsymbol{\epsilon}}_t, } where \eqn{{\bf X}_t = diag(x_{t,1},\ldots,x_{t,d})} is an \eqn{d \times d}
latent process, \eqn{{\bf A}} and \eqn{{\bf B}} are , respectively, \eqn{p
\times d} and \eqn{q \times d} unknown constant matrix, and \eqn{ {\boldsymbol{\epsilon}}_t }
 is a \eqn{p \times q} matrix white noise process. This function aims to estimate the rank
 \eqn{d} and the coefficient matrices \eqn{{\bf A}} and \eqn{{\bf B}}.
}
\examples{
p = 10
q = 10
n = 400
d = d1 = d2 = 3
data <- DGP.CP(n,p,q,d,d1,d2)
Y = data$Y
res1 <- CP_MTS(Y,method = "CP.Direct")
res2 <- CP_MTS(Y,method = "CP.Refined")
res3 <- CP_MTS(Y,method = "CP.Unified")
}
\references{
Chang, J., He, J., Yang, L. and Yao, Q.(2023). \emph{Modelling matrix time series via a tensor CP-decomposition}.
  Journal of the Royal Statistical Society Series B: Statistical Methodology, Vol. 85(1), pp.127--148.
  
  Chang, J., Du, Y., Huang, G. and Yao, Q.(2024+). \emph{On the Identification and Unified Estimation
  Procedure for the Matrix CP-factor Model}, Working paper.
}
