\name{HHscriptnames}
\alias{HHscriptnames}
\alias{WindowsPath}

\title{Find absolute pathname of a script file for the HH book in the HH
  package.}
\description{Find absolute pathname of a script file for the HH book in the \pkg{HH}
  package.}

\usage{
HHscriptnames(chapternumbers=NULL, edition=2)

WindowsPath(x, display=TRUE)
}
\arguments{
  \item{chapternumbers}{A number or letter name for a chapter in the HH
    book.  For the Second edition, the valid values are from the set
    \code{c(1:18, LETTERS[1:15])}.
    For the First edition, the valid values are from the set
    \code{c(1:18)}.
    The argument may be a vector of one or more items.
    The file basename for the corresponding chapter is also accepted.
  If the \code{chapternumbers} is \code{NULL} (the default) then the
  directory containing the script files for the \code{edition} is returned.}
  \item{edition}{Either 2 or 1, for the second or first edition of the
    book \emph{Statistical Analysis and Data Display}.}
  \item{x}{A vector or matrix of pathnames as generated by \R, with \code{"/"} as the
    separator character.}
  \item{display}{Logical.  With the default \code{TRUE}, the
    \code{WindowsPath} function
    prints the pathname on the console with a single \code{\\} character as the
    separator suitable for copy and paste into a Windows program and
    returns its result invisibly.  With
    \code{FALSE}
    the \code{WindowsPath} function does not print anything;  it returns its result visibly.}
}
\value{For \code{HHscriptnames}, matrix of full pathnames to script files in the HH
  package.

For \code{WindowsPath}, a vector or matrix of full pathnames with all \code{"/"} characters
changed to \code{"\\\\"} (which displays as \code{\\} by the
\code{cat} function).  When \code{display} is \code{TRUE} the
function also prints at the console the pathnames with a single
\code{\\} character suitable for copy and paste into a Windows program.
}
\author{ Richard M. Heiberger <rmh@temple.edu> }
\references{
Heiberger, Richard M. and Holland, Burt (2015).
\emph{Statistical Analysis and Data Display: An Intermediate Course with Examples in R}.
Second Edition.
Springer-Verlag, New York.
\url{https://link.springer.com/book/10.1007/978-1-4939-2122-5}
}
\examples{
\dontrun{
  ## All Operating Systems

  ## Second Edition
  HHscriptnames()
  HHscriptnames(6)
  HHscriptnames("6")
  HHscriptnames("oway")

  HHscriptnames("H")
  HHscriptnames("RApx")

  HHscriptnames(c(1:18, LETTERS[1:15]))

  ## with Windows pathname separators
  WindowsPath(HHscriptnames())
  WindowsPath(HHscriptnames(6))
  WindowsPath(HHscriptnames(6), display=FALSE)
  WindowsPath(HHscriptnames(6:8))
  WindowsPath(HHscriptnames(6:8), display=FALSE)

  ## First Edition
  HHscriptnames(6, edition=1)
}
}
\keyword{misc}
