% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classicHIMA.R
\name{classicHIMA}
\alias{classicHIMA}
\title{Classic high-dimensional mediation analysis}
\usage{
classicHIMA(
  X,
  M,
  Y,
  COV.XM = NULL,
  COV.MY = COV.XM,
  Y.type = c("continuous", "binary"),
  M.type = c("gaussian", "negbin"),
  penalty = c("MCP", "SCAD", "lasso"),
  topN = NULL,
  parallel = FALSE,
  ncore = 1,
  scale = TRUE,
  Bonfcut = 0.05,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{a vector of exposure. Do not use \code{data.frame} or \code{matrix}.}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns
represent variables.}

\item{Y}{a vector of outcome. Can be either continuous or binary (0-1). Do not use \code{data.frame} or \code{matrix}.}

\item{COV.XM}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association \code{M ~ X}.
Covariates specified here will not participate penalization. Default = \code{NULL}. If the covariates
contain mixed data types, please make sure all categorical variables are properly formatted as \code{factor} type.}

\item{COV.MY}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association \code{Y ~ M}.
Covariates specified here will not participate penalization. If not specified, the same set of covariates for
\code{M ~ X} will be applied (i.e., \code{COV.XM}. Using different sets of covariates is allowed but this needs to be 
handled carefully.}

\item{Y.type}{data type of outcome (\code{Y}). Either \code{'continuous'} (default) or \code{'binary'}.}

\item{M.type}{data type of mediator (\code{M}). Either \code{'gaussian'} (default) or \code{'negbin'} (i.e., negative binomial).}

\item{penalty}{the penalty to be applied to the model. Either \code{'MCP'} (the default), \code{'SCAD'}, or
\code{'lasso'}.}

\item{topN}{an integer specifying the number of top markers from sure independent screening.
Default = \code{NULL}. If \code{NULL}, \code{topN} will be either \code{ceiling(n/log(n))} for continuous outcome,
or \code{ceiling(n/(2*log(n)))} for binary outcome, where \code{n} is the sample size. If the sample size is greater
than topN (pre-specified or calculated), all mediators will be included in the test (i.e. low-dimensional scenario).}

\item{parallel}{logical. Enable parallel computing feature? Default = \code{FALSE}.}

\item{ncore}{number of cores to run parallel computing Valid when \code{parallel = TRUE}.
By default max number of cores available in the machine will be utilized.}

\item{scale}{logical. Should the function scale the data? Default = \code{TRUE}.}

\item{Bonfcut}{Bonferroni-corrected p value cutoff applied to select significant mediators. Default = \code{0.05}.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}

\item{...}{other arguments passed to \code{ncvreg}.}
}
\value{
A data.frame containing mediation testing results of selected mediators.
\describe{
    \item{Index: }{mediation name of selected significant mediator.}
    \item{alpha_hat: }{coefficient estimates of exposure (X) --> mediators (M) (adjusted for covariates).}
    \item{beta_hat: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for covariates and exposure).}
    \item{IDE: }{mediation (indirect) effect, i.e., alpha*beta.}
    \item{rimp: }{relative importance of the mediator.}
    \item{pmax: }{joint raw p-value of selected significant mediator (based on Bonferroni method).}
}
}
\description{
\code{classicHIMA} is used to estimate and test classic high-dimensional mediation effects (linear & logistic regression).
}
\examples{
\dontrun{
# Note: In the following examples, M1, M2, and M3 are true mediators.
data(himaDat)

# When Y is continuous and normally distributed
# Example 1 (continuous outcome):
head(himaDat$Example1$PhenoData)

hima.fit <- classicHIMA(
  X = himaDat$Example1$PhenoData$Treatment,
  Y = himaDat$Example1$PhenoData$Outcome,
  M = himaDat$Example1$Mediator,
  COV.XM = himaDat$Example1$PhenoData[, c("Sex", "Age")],
  Y.type = "continuous",
  scale = FALSE, # Disabled only for simulation data
  verbose = TRUE
)
hima.fit

# When Y is binary
# Example 2 (binary outcome):
head(himaDat$Example2$PhenoData)

hima.logistic.fit <- classicHIMA(
  X = himaDat$Example2$PhenoData$Treatment,
  Y = himaDat$Example2$PhenoData$Disease,
  M = himaDat$Example2$Mediator,
  COV.XM = himaDat$Example2$PhenoData[, c("Sex", "Age")],
  Y.type = "binary",
  scale = FALSE, # Disabled only for simulation data
  verbose = TRUE
)
hima.logistic.fit
}

}
\references{
Zhang H, Zheng Y, Zhang Z, Gao T, Joyce B, Yoon G, Zhang W, Schwartz J, Just A, Colicino E, Vokonas P, Zhao L,
Lv J, Baccarelli A, Hou L, Liu L. Estimating and Testing High-dimensional Mediation Effects in Epigenetic Studies.
Bioinformatics. 2016. DOI: 10.1093/bioinformatics/btw351. PMID: 27357171; PMCID: PMC5048064
}
