% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/high_dimensional_mean_comparison.R
\name{evaluate_influence_function_multi_factor}
\alias{evaluate_influence_function_multi_factor}
\title{Calculate the test statistics on the left-out samples. Called in debiased_pc_testing().}
\usage{
evaluate_influence_function_multi_factor(
  cross_fitting_sample_1,
  cross_fitting_sample_2 = NULL,
  nuisance_collection,
  num_latent_factor = 1
)
}
\arguments{
\item{cross_fitting_sample_1}{Group 1 sample. Each row is a subject and each column corresponds to a feature.}

\item{cross_fitting_sample_2}{Group 2 sample. Each row is a subject and each column corresponds to a feature.}

\item{nuisance_collection}{A collection of nuisance quantities estimated using "nuisance" samples. It is the output of estimate_nuisance_pc().}

\item{num_latent_factor}{Number of principle components to be considered.}
}
\value{
A list of test statistics.
\item{inner_product_1}{Simple inner products for sample 1.}
\item{inner_product_2}{Simple inner products for sample 2.}
\item{influence_eigenvector_each_subject_1}{Debiased test statistics, sample 1.}
\item{influence_eigenvector_each_subject_2}{Debiased test statistics, sample 1.}
\item{for_variance_subject_1}{Statistics for variance calculation, sample 1.}
\item{for_variance_subject_2}{Statistics for variance calculation, sample 2.}
}
\description{
Calculate the test statistics on the left-out samples. Called in debiased_pc_testing().
}
