% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hvtHmap.R
\name{hvtHmap}
\alias{hvtHmap}
\title{Heat Map over Hierarchical Voronoi Tessellations}
\usage{
hvtHmap(
  hvt.results,
  dataset,
  child.level,
  hmap.cols,
  color.vec = NULL,
  line.width = NULL,
  centroid.size = 3,
  pch = 21,
  palette.color = 6,
  previous_level_heatmap = TRUE,
  show.points = FALSE,
  asp = 1,
  ask = TRUE,
  tess.label = NULL,
  quant.error.hmap = NULL,
  n_cells.hmap = NULL,
  label.size = 0.5,
  ...
)
}
\arguments{
\item{hvt.results}{List. A list of hvt.results obtained from the HVT
function.}

\item{dataset}{Data frame. The input data set.}

\item{child.level}{Numeric. Indicating the level for which the heat map is
to be plotted.}

\item{hmap.cols}{Numeric or Character. The column number of column name from
the dataset indicating the variables for which the heat map is to be
plotted.}

\item{color.vec}{Vector. A color vector such that length(color.vec) =
(child.level - 1). (default = NULL)}

\item{line.width}{Vector. A line width vector such that length(line.width) =
(child.level - 1). (default = NULL)}

\item{centroid.size}{Numeric. Indicating the centroid size of the first
level. (default = 3)}

\item{pch}{Numeric. Indicating the centroid's symbol type.
(default = 21)}

\item{palette.color}{Numeric. Indicating the heat map color palette. 1 -
rainbow, 2 - heat.colors, 3 - terrain.colors, 4 - topo.colors, 5 -
cm.colors, 6 - seas color. (default = 6)}

\item{previous_level_heatmap}{Logical. If TRUE, the heatmap of previous level
will be overlayed on the heatmap of selected level. If #' FALSE, the heatmap
of only selected level will be plotted}

\item{show.points}{Logical. Indicating if the centroids should
be plotted on the tessellations. (default = FALSE)}

\item{asp}{Numeric. Indicating the aspect ratio type. For flexible aspect
ratio set, asp = NA. (default = 1)}

\item{ask}{Logical. If TRUE (and the R session is interactive) the user is
asked for input, before a new figure is drawn. (default = TRUE)}

\item{tess.label}{Vector. A vector for labelling the tessellations. (default
= NULL)}

\item{quant.error.hmap}{Numeric. A number indicating the quantization error
threshold.}

\item{n_cells.hmap}{Numeric. An integer indicating the number of
cells/clusters per hierarchy (level)}

\item{label.size}{Numeric. The size by which the tessellation labels should
be scaled. (default = 0.5)}

\item{...}{The ellipsis is passed to it as additional argument. (Used internally)}
}
\value{
Returns the ggplot object containing scatter plot for the selected
depth level containing the centroids of each cell
}
\description{
Main function to construct heatmap overlay for hierarchical voronoi tessellations.
}
\details{
The output of the \code{HVT} function has all the required information about
the HVT. Now a heat map is overlayed over this HVT. The user defines the
level and also those variables of the data for which the heat map is to be
plotted. Now for each variable a separate heat map is plotted. The plot area
is divided into 2 screens where the first screen is relatively large and
will have the heat map. The second screen is small and contains the gradient
scale. To plot the heat map, the data is first normalized. The gradient
scale is divided into 'n' regions(500 is the set default). Using the
normalized data, the different regions into which the data items fall are
found. Each data item is now having a region on the gradient scale. This
color is filled in the tile corresponding to the data item. This procedure
is done for all the tiles for that level to get the complete heat map. Once
the heat map is ready, the higher level tessellations are plotted to
represent the hierarchies. The size of the centroids, the thickness of the
lines and the color of the tessellation lines can be given as input by the
user. Appropriate values for these parameters should be given to identify
the hierarchies properly. In the second screen the gradient scale is
plotted. The heat maps and hierarchical tessellations are obtained for all
the desired variables.
}
\examples{
data(USArrests)
hvt.results <- list()
hvt.results <- HVT(USArrests,
  n_cells = 15, depth = 1, quant.err = 0.2,
  distance_metric = "L1_Norm", error_metric = "mean",
  projection.scale = 10, normalize = TRUE,
  quant_method = "kmeans", diagnose = TRUE
)
hvtHmap(hvt.results, USArrests,
  child.level = 1, hmap.cols = "Murder",
  line.width = c(0.2), color.vec = c("#141B41"), palette.color = 6,
  quant.error.hmap = 0.2, n_cells.hmap = 6
)
}
\seealso{
\code{\link{plotHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>, Sangeet Moy Das <sangeet.das@mu-sigma.com>
}
\keyword{hplot}
