% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displayTable.R
\name{displayTable}
\alias{displayTable}
\title{Table for displaying summary}
\usage{
displayTable(
  data,
  columnName,
  value,
  tableType = "summary",
  scroll = TRUE,
  limit = 100
)
}
\arguments{
\item{data}{List. A listed object from trainHVT or scoreHVT}

\item{columnName}{Character. Name of the column that needs highlighting.}

\item{value}{Numeric. The value above will be highlighted in red or green.}

\item{tableType}{Character. Type of table to generate ('summary', 'compression')}

\item{scroll}{Logical. A value to have a scroll or not in the table.}

\item{limit}{Numeric. A value to indicate how many rows to display.
Applicable for summary tableType.}
}
\value{
A consolidated table of results
}
\description{
This is the main function for displaying summary from model training and scoring
}
\examples{
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                      DAX = EuStockMarkets[, "DAX"],
                      SMI = EuStockMarkets[, "SMI"],
                      CAC = EuStockMarkets[, "CAC"],
                      FTSE = EuStockMarkets[, "FTSE"])
hvt.results<- trainHVT(dataset,n_cells = 60, depth = 1, quant.err = 0.1,
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method = "kmeans")
displayTable(data = hvt.results[[3]]$compression_summary,
columnName = 'percentOfCellsBelowQuantizationErrorThreshold', 
value = 0.8, tableType = "compression")

displayTable(data =hvt.results[[3]][['summary']], columnName= 'Quant.Error',
 value = 0.1, tableType = "summary")
}
\seealso{
\code{\link{trainHVT}}
}
\author{
Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{EDA}
