% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diag_Heckman-t.R
\name{CaseDeletion}
\alias{CaseDeletion}
\title{Case deletion analysis for Heckman selection model}
\usage{
CaseDeletion(object)
}
\arguments{
\item{object}{A HeckmanEM object.}
}
\value{
A list of class \code{HeckmanEM.deletion} with a vector GD of dimension \eqn{n} (see details), and a benchmark value.
}
\description{
This function performs case deletion analysis based on a HeckmanEM object.
}
\details{
This function uses the case deletion approach to study
the impact of deleting one or more observations from the dataset
on the parameters estimates, using the ideas of Cook (1977) and Zhu et.al. (2001).
The GD vector contains the generalized Cook distances
\deqn{\textrm{GD}^1_i = \dot{Q}_{[i]}(\widehat{\boldsymbol{\theta}} \mid \widehat{\boldsymbol{\theta}})^{\top} \left\{-\ddot{Q}(\widehat{\boldsymbol{\theta}} \mid \widehat{\boldsymbol{\theta}})\right\}^{-1}\dot{Q}_{[i]}(\widehat{\boldsymbol{\theta}} \mid \widehat{\boldsymbol{\theta}}),}
where \eqn{\dot{Q}_{[i]}(\widehat{\boldsymbol{\theta}}\mid \widehat{\boldsymbol{\theta}})} is the gradient vector after dropping the \eqn{i}th observation, and
\eqn{\ddot{Q}(\widehat{\boldsymbol{\theta}} \mid \widehat{\boldsymbol{\theta}})} is the Hessian matrix. The benchmark was adapted using the suggestion of Barros et al. (2010). We use \eqn{(2 \times \textrm{npar})/n} as the benchmark for the \eqn{\textrm{GD}_i}, with \eqn{\textrm{npar}} representing the number of estimated model parameters.
}
\examples{
n    <- 100
nu   <- 3
cens <- 0.25

set.seed(13)
w <- cbind(1, runif(n, -1, 1), rnorm(n))
x <- cbind(w[,1:2])
c <- qt(cens, df = nu)

sigma2   <- 1
beta     <- c(1, 0.5)
gamma    <- c(1, 0.3, -.5)
gamma[1] <- -c * sqrt(sigma2)

datas <- rHeckman(x, w, beta, gamma, sigma2, rho = 0.6, nu, family = "T")
y     <- datas$y
cc    <- datas$cc
\donttest{
heckmodel <- HeckmanEM(y, x, w, cc, family = "Normal", iter.max = 50)

global <- CaseDeletion(heckmodel)
plot(global)
}
}
\references{
M. Barros, M. Galea, M. González, V. Leiva, Influence diagnostics in the Tobit censored response model, Statistical Methods & Applications 19 (2010) 379–397.

R. D. Cook, Detection of influential observation in linear regression, Technometrics 19 (1977) 15–18.

H. Zhu, S. Lee, B. Wei, J. Zhou, Case-deletion measures for models with incomplete data, Biometrika 88 (2001) 727–737.
}
