% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meltData.r
\name{meltData}
\alias{meltData}
\title{meltData}
\usage{
meltData(formula, data, vnames = c("labels", "names"))
}
\arguments{
\item{formula}{a formula}

\item{data}{data frame or table}

\item{vnames}{set to \code{names} to always use variable names instead of labels for X}
}
\value{
data table
}
\description{
Melt a Dataset To Examine All Xs vs Y
}
\details{
Uses a formula with a single left hand side variable (Y) and one or more numeric right hand side variables (X).  Uses \code{\link[data.table:melt.data.table]{data.table::melt()}} to melt \code{data} so that each X is played against the same Y.  The resulting data table has variables Y with its original name, \code{variable}, and \code{value}.  By default \code{variable} is taken as \code{label()}s of X variables.
}
\examples{
d <- data.frame(y=(1:10)/10, x1=1:10, x2=101:110)
label(d$x1) <- 'X1'
m=meltData(y ~ x1 + x2, data=d)
print(m)
}
\seealso{
\code{\link[=label]{label()}}
}
\author{
Frank Harrell
}
