% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructKnots.R
\name{constructKnots}
\alias{constructKnots}
\title{constructKnots}
\usage{
constructKnots(sData, nKnots = NULL, knotDist = NULL, minKnotDist = NULL)
}
\arguments{
\item{sData}{a dataframe containing spatial or temporal coordinates of units of the random level}

\item{nKnots}{the number of knots wanted on the spatial dimension with the shortest range}

\item{knotDist}{the distance between the wanted knots}

\item{minKnotDist}{the minimum distance of a knot to the nearest data point}
}
\value{
a data frame with knot locations
}
\description{
construct a regular spaced grid with knot locations to be used in spatial
Hmsc models with the spatial method set to GPP. Knot locations with a distance greater than minKnotDist to
the nearest data point are dropped from the grid.
}
\details{
Only one of \code{nKnots} and \code{minKnotDist} arguments can be provided.
}
\examples{
#Creating knots for some 2 dimensional spatial data
n = 100
xycoords = matrix(runif(2*n),ncol=2)
xyKnots = constructKnots(xycoords,knotDist = 0.2, minKnotDist = 0.5)

}
