% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyramid.R
\name{plot_pyramid}
\alias{plot_pyramid}
\title{Plot an age pyramid from age pyramid data frame.}
\usage{
plot_pyramid(
  pyramid,
  group_colors,
  group_legend = "Group",
  age_breaks,
  value_breaks
)
}
\arguments{
\item{pyramid}{Age pyramid of a population. Dataframe containing at least \code{age} and \code{value} columns.

\emph{(Optional)} For plotting an age pyramid composed of several subgroups, the population data frame must contain a column named \code{group_name}.}

\item{group_colors}{\emph{(Optional)} Named character vector.}

\item{group_legend}{\emph{(Optional)} Legend title name. By default set to \code{"Group"}.}

\item{age_breaks}{\emph{(Optional)} An ordered vector of indexes of vector \code{unique(pyr$age)} used for breaks for the axis of ages.}

\item{value_breaks}{\emph{(Optional)} Breaks for the axis of values.}
}
\value{
Plot of the age pyramid.
}
\description{
Plot an age pyramid from age pyramid data frame with possibly several characteristics. See also \code{\link{plot_population}}.
}
\examples{
plot_pyramid(subset(EW_pop_14$age_pyramid, as.numeric(age) <= 110))

\donttest{
library(colorspace)
pyr_IMD <- subset(EW_popIMD_14$age_pyramid, as.numeric(age) <= 110)
pyr_IMD$group <- with(pyr_IMD, ifelse(male, paste('Males - IMD', IMD), paste('Females - IMD', IMD)))
colors <- c(sequential_hcl(n=5, palette = "Magenta"),
            sequential_hcl(n=5, palette = "Teal"))
names(colors) <- c(paste('Females - IMD', 1:5),
                   paste('Males - IMD', 1:5))
# note that you must have setequal(names(colors), pyr_IMD$group) is TRUE
plot_pyramid(pyr_IMD, colors)
}
}
