% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{stepfun}
\alias{stepfun}
\title{Step Function.}
\usage{
stepfun(x, y)
}
\arguments{
\item{x}{Numeric vector giving the knots or jump locations of the step function. Must be sorted with unique values.}

\item{y}{Numeric vector one longer than x, giving the heights of the function values between the c\code{x} values.}
}
\value{
Objet of class \code{\link[stats]{stepfun}} with option \code{right = FALSE} (cadlag function).
}
\description{
Given the vectors \verb{(x[1],...,x[n])} and \verb{(y[0],y[1],...,y[n])} (one value more!), \code{stepfun(x, y)} returns an interpolating step function, say \code{f_n}. This is the cadlag version (\code{right = FALSE}) of the \code{stepfun} function from package \code{stats}. The step function value \code{f_n(t)} equals to the constant \code{y[k-1]} for \code{t} in \verb{[x[k-1], x[k])} so that
\deqn{f_n(t) = \sum_{k=1}^{n+1} y_{k-1} {1}_{[x_{k-1}, x_{k})}(t),}
with\eqn{x_0=-\infty} and \eqn{x_{n+1}=+\infty}.
}
\details{
This function is defined for documentation purposes only. See \code{\link[stats]{stepfun}} and \code{\link[stats]{approxfun}}.

A C++ version of this function is available. See \code{vignette('IBMPopSim_cpp')} for more details.
}
\seealso{
\code{\link[stats]{plot.stepfun}} and \code{\link{max.stepfun}}.
}
