% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibrv2_chart.R
\name{ibrv2_chart}
\alias{ibrv2_chart}
\title{IBRv2 Radarchart}
\usage{
ibrv2_chart(
  df,
  axistype,
  pcol,
  pfcol,
  plwd,
  plty,
  cglcol,
  cglty,
  axislabcol,
  cglwd,
  caxislabels,
  seg,
  legend = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame that resulted from the function ibrv2_std}

\item{axistype}{The type of axes, specified by any of 0:5.  0 means no axis label.  1 means center axis label only.  2 means around-the-chart label only.  3 means both center and around-the-chart (peripheral) labels.  4 is *.** format of 1, 5 is *.** format of 3.  Default is 0.}

\item{pcol}{A vector of color codes for plot data: Default 1:8, which are repeatedly used.}

\item{pfcol}{A vector of color codes for filling polygons: Default NA, which is repeatedly usd.}

\item{plwd}{A vector of line widths for plot data: Default 1, which is repeatedly used.}

\item{plty}{A vector of line types for plot data: Default 1:6, which are repeatedly used.}

\item{cglcol}{Line color for radar grids: Default "navy"}

\item{cglty}{Line type for radar grids: Default 3, which means dotted line.}

\item{axislabcol}{Color of axis label and numbers: Default "blue"}

\item{cglwd}{Line width for radar grids: Default 1, which means thinnest line.}

\item{caxislabels}{Character vector for center axis labels, overwriting values specified in axistype option.  If NULL, the values specified by axistype option are used. Default is NULL.}

\item{seg}{The number of segments for each axis (default 4).}

\item{legend}{Default is NULL, when any other value is given the legend will not appear and you can manually create your own using the legend() function right after building your radarchart}

\item{...}{Miscellaneous arguments to be given for plot.default().}
}
\value{
Returns a radarchart with the standardized values of biomarkers in comparison to reference treatment
}
\description{
Plots the IBRv2 standardized values for the enzymes to be compared with one another.
}
\section{Tips}{


For this index chart, it is necessary to plot each area/treatment with the reference value separately, therefore, make sure you subset the data.frame and perform this function for each subset.

Also, you will find that the axis values are not written automatically, we suggest that our users do it manually because we couldn't yet provide an automated way to plot the zero in the correct position on the radarchart. This will be revised for next versions of this package. This can be done by changing values for seg, axistype = 1, and caxislabels.

Check the examples for further insight.
}

\section{References}{


Sanchez, W., Burgeot, T., & Porcher, J.-M. (2013). A novel “Integrated Biomarker Response” calculation based on reference deviation concept. Environmental Science and Pollution Research, 20(5), 2721–2725. https://doi.org/10.1007/s11356-012-1359-1

Minato Nakazawa (2022). fmsb: Functions for Medical Statistics Book with some Demographic Data. R package version 0.7.0. https://CRAN.R-project.org/package=fmsb
}

\examples{
data(enzact2)

ibrv2_bdi(enzact2) -> enzact2_std

# subsetting to compare one area with the reference value

enzact2_std[c(1,2),] -> sub1_enzact2_std

ibrv2_chart(sub1_enzact2_std)

ibrv2_chart(sub1_enzact2_std, seg =8, caxislabels = seq(-1,1.9,0.34), axistype = 1)

}
