% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FIM_logistic_4par}
\alias{FIM_logistic_4par}
\title{Fisher information matrix for the four parameter logistic model.}
\usage{
FIM_logistic_4par(x, w, param)
}
\arguments{
\item{x}{vector of design points.}

\item{w}{vector of design weight. Its length must be equal to the length of \code{x} and \code{sum(w)} should be 1.}

\item{param}{vector of model parameters
\eqn{\bold{\theta} = (\theta_1, \theta_2, \theta_3, \theta_4)}{\bold{\theta} = (\theta1, \theta2, \theta3, \theta4)}.}
}
\value{
Fisher information matrix.
}
\description{
The mean of the response variable is
 \deqn{f(x, \bold{\theta}) = \frac{\theta_1}{1 + \exp(\theta_2 x + \theta_3)} + \theta_4,}{
 f(x, \bold{\theta})= \theta1/(1 + exp(\theta2*x + \theta3)) + \theta4,}
  where \eqn{\bold{\theta} = (\theta_1, \theta_2, \theta_3, \theta_4)}{\bold{\theta} = (\theta1, \theta2, \theta3, \theta4)}.
}
\details{
The fisher information matrix does not depend on \eqn{\theta_4}{\theta4}.\cr
There is no analytical solution for the locally D-optimal design for this model.
}
\seealso{
Other FIM: \code{\link{FIM_comp_inhibition}},
  \code{\link{FIM_emax_3par}}, \code{\link{FIM_exp_2par}},
  \code{\link{FIM_exp_3par}},
  \code{\link{FIM_logisitic_1par}},
  \code{\link{FIM_logistic}}, \code{\link{FIM_loglin}},
  \code{\link{FIM_michaelis}},
  \code{\link{FIM_mixed_inhibition}},
  \code{\link{FIM_noncomp_inhibition}},
  \code{\link{FIM_power_logistic}},
  \code{\link{FIM_uncomp_inhibition}}
}

