IDSL.NPA_workflow <- function(spreadsheet) {
  ##
  tryCatch(stop(""), error = function(e){""}) # To clear cache of error messages
  on.exit({
    sillyErrors <- c("",
                     "subscript out of bounds",
                     "StopIteration", # StopIteration is generated by `foreach`
                     "cannot shut down device 1 (the null device)") # error by `dev.off()`
    ##
    errorMessages <- geterrmessage()
    xSillyErrors <- which(!(errorMessages %in% sillyErrors))
    if (length(xSillyErrors) > 0) {
      FSA_logRecorder(errorMessages[xSillyErrors])
      FSA_logRecorder("Stopped IDSL.NPA workflow!")
    }
    ##
    if (exists('.logFSA')) {
      rm(.logFSA, envir = .GlobalEnv)
    }
  })
  ##
  gc()
  closeAllConnections()
  ##############################################################################
  PARAM_total <- IDSL.NPA_xlsxAnalyzer(spreadsheet)
  PARAM_Start <- PARAM_total[["PARAM_Start"]]
  if (!is.null(PARAM_Start)) {
    PARAM0001 <- tolower(PARAM_Start[which(PARAM_Start[, 1] == "PARAM0001"), 2])
    PARAM0002 <- tolower(PARAM_Start[which(PARAM_Start[, 1] == "PARAM0002"), 2])
    PARAM0003 <- tolower(PARAM_Start[which(PARAM_Start[, 1] == "PARAM0003"), 2])
    ##
    if (PARAM0001 == "yes") {
      PARAM_NPA <- PARAM_total[["PARAM_NPA"]]
      if (!is.null(PARAM_NPA)) {
        NPA_workflow(PARAM_NPA)
      } else {
        stop()
      }
    }
    ############################################################################
    if (PARAM0003 == "yes") {
      output_path <- PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0006'), 2]
    }
    ############################################################################
    if (PARAM0002 == "yes") {
      ##
      PARAM_FSdb <- PARAM_total[["PARAM_FSdb"]]
      libFSdb <- FSdb_file_generator(PARAM_FSdb, output_path)
      ##
      if (PARAM0003 == "yes") {
        .logFSA <- NULL
        .logFSA <<- paste0(output_path, "/logFSA_msp_annotation.txt")
        FSA_logRecorder(paste0(rep("", 100), collapse = "="))
        address_FSDB <- PARAM_FSdb[which(PARAM_FSdb[, 1] == "FSdb0003"), 2]
        exportFSdbCheck <- if (tolower(address_FSDB) == "na") {FALSE} else {TRUE}
        if (exportFSdbCheck) {
          name_FSDB <- PARAM_FSdb[which(PARAM_FSdb[, 1] == "FSdb0004"), 2]
          FSdb_file <- paste0(address_FSDB, "/", name_FSDB, ".Rdata")
          FSdb_file <- gsub("\\", "/", FSdb_file, fixed = TRUE)
          ##
          FSA_logRecorder(paste0("The Fragmentation Spectra DataBase (FSDB) library is used from `", FSdb_file, "`!"))
        } else {
          FSA_logRecorder("The generated Fragmentation Spectra DataBase (FSDB) library is used for annotation!")
        }
      }
      ##
    } else if (PARAM0002 == "no") {
      ##
      if (PARAM0003 == "yes") {
        ##
        if (PARAM0003 == "yes") {
          .logFSA <- NULL
          .logFSA <<- paste0(output_path, "/logFSA_msp_annotation.txt")
          FSA_logRecorder(paste0(rep("", 100), collapse = "="))
        }
        ##
        FSdb_file <- PARAM_Start[which(PARAM_Start[, 1] == "PARAM0004"), 2]
        FSA_logRecorder(paste0("Loading the Fragmentation Spectra DataBase (FSDB) library from `", FSdb_file, "`!"))
        libFSdb <- IDSL.IPA::loadRdata(FSdb_file)
      }
    }
    ##
    ############################################################################
    if (PARAM0003 == "yes") {
      ##
      address_input_msp <- PARAM_Start[which(PARAM_Start[, 1] == 'PARAM0005'), 2]
      ##
      IDSL.IPA::opendir(output_path)
      ##
      PARAM_SPEC <- PARAM_total[["PARAM_SPEC"]]
      ##
      FSA_msp_annotator(PARAM_SPEC, libFSdb, address_input_msp, output_path)
    }
    ############################################################################
    ##
    gc()
    closeAllConnections()
    ##
  }
}
