% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportToNumpy.R
\name{ExportToNumpy}
\alias{ExportToNumpy}
\title{Numpy Export}
\usage{
ExportToNumpy(
  ...,
  objects,
  offsets,
  image_type = "img",
  size = c(64, 64),
  force_width = FALSE,
  display_progress = TRUE,
  python = Sys.getenv("RETICULATE_PYTHON"),
  dtype = c("uint8", "int16", "uint16", "double")[3],
  mode = c("raw", "gray")[1],
  export = c("file", "matrix")[2],
  write_to,
  overwrite = FALSE
)
}
\arguments{
\item{...}{arguments to be passed to \code{\link{objectExtract}} with the exception of 'ifd' and 'bypass'(=TRUE).\cr
If 'param' is provided the above parameters will be overwritten.\cr
If 'offsets' are not provided extra arguments can also be passed with ... \code{\link{getOffsets}}.\cr
/!\ If not any of 'fileName', 'info' and 'param' can be found in ... then attr(offsets, "fileName_image") will be used as 'fileName' input parameter to pass to \code{\link{objectParam}}.}

\item{objects}{integer vector, IDEAS objects ids numbers to use.
This argument is not mandatory, if missing, the default, all objects will be used.}

\item{offsets}{object of class `IFC_offset`. 
This argument is not mandatory but it may allow to save time for repeated image export on same file.}

\item{image_type}{image_type of desired offsets. Either "img" or "msk". Default is "img".}

\item{size}{a length 2 integer vector of final dimensions of the image, height 1st and width 2nd. Default is c(64,64).}

\item{force_width}{whether to use information in 'info' to fill size. Default is FALSE.
When set to TRUE, width of 'size' argument will be overwritten.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{python}{path to python. Default is Sys.getenv("RETICULATE_PYTHON").\cr
Note that this numpy should be available in this python to be able to export to numpy array file, otherwise 'export' will be forced to "matrix".}

\item{dtype}{desired array?s data-type. Default is "double". Allowed are "uint8", "int16", "uint16" or "double". If 'mode' is "raw", this parameter will be forced to "int16".}

\item{mode}{(\code{\link{objectParam}} argument) color mode export. Either "raw", "gray" . Default is "raw".}

\item{export}{export format. Either "file", "matrix". Default is "matrix".\cr
Note that you will need 'reticulate' package installed to be able to export to numpy array file, otherwise 'export' will be forced to "matrix".}

\item{write_to}{used when 'export' is "file" to compute respectively filename.
Exported type will be deduced from this pattern. Allowed export are '.npy'.\cr
Placeholders, if found, will be substituted:\cr
-\%d: with full path directory\cr
-\%p: with first parent directory\cr
-\%e: with extension of (without leading .)\cr
-\%s: with shortname (i.e. basename without extension)\cr
-\%o: with objects (at most 10, will be collapse with "_", if more than one).\cr
-\%c: with channel_id (will be collapse with "_", if more than one, composite in any will be bracketed).
A good trick is to use:\cr
-"\%d/\%s_Obj[\%o]_Ch[\%c].npy", when 'export' is "file"\cr}

\item{overwrite}{whether to overwrite file or not. Default is FALSE.}
}
\value{
Depending on 'export':\cr
-"matrix", an array whose dimensions are [object, height, width, channel].\cr
-"file", it invisibly returns path of .npy exported file.
}
\description{
Exports IFC objects to numpy array [objects,height,width,channels]
}
\details{
arguments of \code{\link{objectExtract}} will be deduced from \code{\link{ExportToNumpy}} input arguments.\cr
Please note that size parameter has to be supplied and could not be set to (0,) when 'object' length is not equal to one\cr
\code{\link{ExportToNumpy}} requires reticulate package, python and numpy installed to create npy file.\cr
If one of these is missing, 'export' will be set to "matrix".
}
