% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subnet_cor.R
\name{subnet_cor}
\alias{subnet_cor}
\title{Correlation of the Structural indices between Subnetworks}
\usage{
subnet_cor(network.or.subnet_mat1, subnet_mat2 = NULL, weighted = FALSE)
}
\arguments{
\item{network.or.subnet_mat1}{Either a 'igraph' multilayer(tripartite) network, or a numeric matrix(or data.frame) representing interactions between two groups of species. The network containS
interlayer links and without intralayer links. Each row and column of matrix represents the species in the first and second layers of the tripartite network,respectively. Elements of matrix are non-zero
nnumebers if the interlayer species are connected, and 0 otherwise.}

\item{subnet_mat2}{A numeric matrix(or data.frame) representing interactions between two groups of species.Each row and column of matrix represents the species in the second and third layers of the
tripartite network,respectively. Elements of matrix are non-zero numebers if the interlayer species are connected, and 0 otherwise.}

\item{weighted}{Logical. should elements of matrix be fractional? Default to FALSE. Generally, 'igraph' network represent a spare matrix, so \code{weighted} is FALSE. While elements of matrix represent interaction strength, \code{weighted} is TRUE.}
}
\value{
Return a numeric vector of two elements representing correlation of interconnecting species generalism among Subnetworks and correlation between similarities of interconnecing species interaction partners in two subnetworks.

If \code{weighted} = FALSE, the results will show "general_cor=  ;similar_cor=  ;" and If \code{weighted} = TRUE, the results will show "general_weight_cor=  ;similar_weight_cor=  ;"
}
\description{
Calculating correlation of interconnecting species generalism among Subnetworks ("general_'~'cor") and correlation between similarities of interconnecing species interaction partners in two subnetworks ("similar_'~'cor").
}
\details{
\strong{weighted}

If the \code{weighted} = FALSE, the input for the parameter can be:
\code{network.or.subnet_mat1}: input a 'igraph' of network data independently or input sparse matrix together with \code{subnet_mat2}.

If the \code{weighted} = TRUE, the input for the parameter can be:
\code{network.or.subnet_mat1}: must input matrix(or data.frame) together with \code{subnet_mat2}. the matrix can be sparse matrix and matrix of interaction strength.
}
\examples{

set.seed(12)
d <- build_net(11,15,17,0.2)
subnet_cor(d)

md1<-matrix(sample(c(0,1),100,replace=TRUE),10,10)
md2<-matrix(sample(c(0,1),120,replace=TRUE),10,12)
subnet_cor(md1,md2)
subnet_cor(md1,md2,weighted=TRUE)

mdw1<-matrix(runif(100,0,1),10,10)
mdw2<-matrix(runif(120,0,1),10,12)
subnet_cor(mdw1,mdw2,weighted=TRUE)

}
\references{
Sauve, A. M., Thébault, E., Pocock, M. J., & Fontaine, C. (2016). How plants connect pollination and herbivory networks and their contribution to community stability. Ecology, 97(4), 908-917.
}
