#' Rearrange columns in output tibble from IND~pressure modeling functions
#'
#' \code{sort_output_tbl} is a helper function for all IND~pressure
#' modeling functions and rearranges columns so that all output tibbles show
#' the same order of variables. This is a generic function in the sense that
#' all other variables not  considered in the sorting list here are placed at
#' the end. That way, any modified tibble can be used as input.
#'
#'
#' @param mod_tbl A tibble, e.g. tibbles generated by the IND~pressure
#'  modeling functions
#'
#' @return
#' The function returns a re-arranged input tibble.
#'
#' @keywords internal
#' @export
#'
sort_output_tbl <- function(mod_tbl) {
  # Create vector with all potential variables
  defined_var <- c("id", "ind_id", "ind", "press",
    "model_type", "corrstruc", "aic", "edf", "p_val",
    "signif_code", "r_sq", "expl_dev", "nrmse",
    "ks_test", "tac", "pres_outlier", "excl_outlier",
    "model", "prop", "zero_in_conf", "zic_start_end",
    "adj_n_boot", "boot_error", "press_seq", "pred",
    "pred_ci_up", "pred_ci_low", "deriv1", "deriv1_ci_up",
    "deriv1_ci_low", "excl_outlier_boot", "interaction",
    "thresh_var", "thresh_models", "thresh_error",
    "tac_in_thresh")

  # Variables in tibble
  nam <- names(mod_tbl)
  # Get existing variables in mod_tbl and order them
  # accordingly
  order_var <- defined_var[!is.na(match(defined_var,
    nam))]
  # Add the other variables not in all_var
  others <- nam[is.na(match(nam, defined_var))]
  all_var <- c(order_var, others)
  mod_tbl <- mod_tbl %>% dplyr::select_(.dots = all_var)

  return(mod_tbl)
}
