% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_sc.R
\name{summary_sc}
\alias{summary_sc}
\title{Summary of indicator performance scores}
\usage{
summary_sc(scores_tbl, crit_scores = INDperform::crit_scores_tmpl)
}
\arguments{
\item{scores_tbl}{The output tibble from the \code{\link{scoring}}
function.}

\item{crit_scores}{The(un)modified criterion-scoring template
\code{crit_scores_tmpl}; required to calculate the scores in
percentage. Has to be the same than used in \code{scoring}. Default
is the unmodified template \code{crit_scores_tmpl}.}
}
\value{
The function returns a list of 2 data frames
\describe{
  \item{\code{overview}}{IND-specific scores and percentages from
        max. score for all criteria (crit 9 and 10 averaged across
        all sign. pressures and the number of significant pressures).}
  \item{\code{subcriteria_per_press}}{IND- and pressure-specific scores for
         all (sub-)criteria and the percentages from max. criterion score.}
}
}
\description{
Summarizes the scoring output tibble so that IND-specific scores for each
criterion as well as the pressure-specific sub-criteria scores (in crit.
9 and 10) can be easily compared.
}
\examples{
# Using the Baltic Sea demo data in this package
scores_tbl <- scoring(trend_tbl = model_trend_ex, mod_tbl = all_results_ex,
  press_type = press_type_ex)
summary_sc(scores_tbl)
}
\seealso{
Other score-based IND performance functions: \code{\link{clust_sc}},
  \code{\link{dist_sc}}, \code{\link{expect_resp}},
  \code{\link{plot_clust_sc}},
  \code{\link{plot_spiechart}}, \code{\link{scoring}}
}
