% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSet.R, R/DataSetList.R
\name{get_PAR_sample}
\alias{get_PAR_sample}
\alias{get_PAR_sample.DataSet}
\alias{get_PAR_sample.DataSetList}
\title{Get Parameter Value Samples}
\usage{
get_PAR_sample(ds, ftarget, ...)

\method{get_PAR_sample}{DataSet}(ds, ftarget, parId = "all",
  output = "wide", ...)

\method{get_PAR_sample}{DataSetList}(ds, ftarget, algorithm = "all", ...)
}
\arguments{
\item{ds}{A DataSet or DataSetList object}

\item{ftarget}{A Numerical vector. Function values at which parameter values are observed}

\item{...}{Arguments passed to other methods}

\item{parId}{A character vector. Either 'all' or the name of parameters to be retrieved}

\item{output}{A character. The format of the output data: 'wide' or 'long'}

\item{algorithm}{Which algorithms in the DataSetList to consider.}
}
\value{
A data.table object containing parameter values aligned at each given target value
}
\description{
Get Parameter Value Samples
}
\examples{
get_PAR_sample(dsl, 14)
get_PAR_sample(dsl[[1]], 14)
}
