% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISRaD.save.xlsx.R
\name{ISRaD.save.xlsx}
\alias{ISRaD.save.xlsx}
\title{ISRaD.save.xlsx}
\usage{
ISRaD.save.xlsx(database, template_file = system.file("extdata",
  "ISRaD_Master_Template.xlsx", package = "ISRaD"), outfile)
}
\arguments{
\item{database}{ISRaD data object.}

\item{template_file}{Directory path and name of template file to use (defaults to the ISRaD_Master_Template file built into the package). Not recommended to change this.}

\item{outfile}{Directory path and file name for saving .xlsx file}
}
\description{
Saves ISRaD data object as .xlsx file in ISRaD template format
}
\examples{
\donttest{
# Load example dataset Gaudinski_2001
database <- ISRaD::Gaudinski_2001
ISRaD.save.xlsx(database = database,
 template_file = system.file("extdata", "ISRaD_Master_Template.xlsx", package = "ISRaD"),
 outfile = paste0(tempdir(),"/Gaudinski_2001.xlsx"))
}
}
\author{
J Grey Monroe
}
