% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_insilico.r
\name{print.insilico}
\alias{print.insilico}
\title{Print method for summarizing InSilicoVA Model Fits}
\usage{
\method{print}{insilico}(x, ...)
}
\arguments{
\item{x}{\code{insilico} object.}

\item{...}{not used}
}
\description{
This function is the print method for class \code{insilico}.
}
\examples{
\dontrun{
# load sample data together with sub-population list
data(RandomVA1)
# extract InterVA style input data
data <- RandomVA1$data
# extract sub-population information. 
# The groups are "HIV Positive", "HIV Negative" and "HIV status unknown".
subpop <- RandomVA1$subpop

# run without subpopulation
fit1<- insilico( data, subpop = NULL, 
              Nsim = 400, burnin = 200, thin = 10 , seed = 1,
              external.sep = TRUE, keepProbbase.level = TRUE)
fit1
}
}
\references{
Tyler H. McCormick, Zehang R. Li, Clara Calvert, Amelia C. Crampin,
Kathleen Kahn and Samuel J. Clark Probabilistic cause-of-death assignment
using verbal autopsies, \emph{Journal of the American Statistical
Association} (2016), 111(515):1036-1049.
}
\seealso{
\code{\link{summary.insilico}}
}
\author{
Zehang Li, Tyler McCormick, Sam Clark

Maintainer: Zehang Li <lizehang@uw.edu>
}
