% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importPlatemap.R
\name{importPlatemap}
\alias{importPlatemap}
\title{importPlatemap}
\usage{
importPlatemap(input, control_cpd = "DMSO")
}
\arguments{
\item{input}{Either a path to a text file or a data frame}

\item{control_cpd}{Specify the compound to use as baseline.  Defaults to DMSO}
}
\value{
IncucyteDRCPlateMap object
}
\description{
Imports a platemap configuration from a tab delimited file or dataframe.
}
\examples{
pm_file <- system.file(file='extdata/example_platemap.txt', package='IncucyteDRC')
test_pm <- importPlatemap(pm_file)
head(test_pm)
test_pm_df <- importPlatemap(as.data.frame(test_pm))
head(test_pm_df)
}

